function visible = isvisible(x_V, x_W, map)
%input arguments: vantage point x_V [2x1], surveillance point x_W [2x1],
%occupancy grid map [xmax x ymax]
%output arguments: boolean visible, corresponding to visibility of x_W from
%x_V

% input argument error checking
if nargin ~= 3
    error('Wrong number of input arguments');
end
if ~(size(x_V, 1)==2 && size(x_V, 2)==1)
    error('Wrong size of x_V')
end
if ~(size(x_W, 1)==2 && size(x_W, 2)==1)
    error('Wrong size of x_W')
end

% aliases
x0 = x_V(1); y0 = x_V(2); x1 = x_W(1); y1 = x_W(2);

%visibility checking
visible = 1;
jprev = ceil(y0);
for i = ceil(x0):sign(x1-x0):ceil(x1)
    if (i==ceil(x1)) %endpoint condition - avoid overshooting
        jnext = ceil((y1-y0)/(x1-x0)*(x1-x0)+y0);
    elseif (x1>x0)
        jnext = ceil((y1-y0)/(x1-x0)*(i-x0)+y0);
    else
        jnext = ceil((y1-y0)/(x1-x0)*(i-1-x0)+y0);
    end
    for j = jprev:sign(y1-y0):jnext
        if (map(i,j)==1)
            visible = 0;
            return
        end
    end
    jprev = jnext;
end