%run_newton defines a starting point and trajectory and
%calls Newton() with the appropriate arguments.  You 
%will need to specify the trajectory where asked.

Qhome = [1.6; 0.17]; %joint angles for robot home position
                     %(and starting point for Newton)
Xhome = robot_f(Qhome,[0;0]); %X coordinates for robot home position

%SPECIFY TRAJECTORY ON FOLLOWING LINE (don't include Xhome
%because that will be added in the Xvec definition below).
Xadd = %X trajectory vectors (not including Xhome)

Xvec = [Xhome, Xadd]; %full trajectory is the concatenation
                        %of Xhome and Xadd

%call Newton (see Newton.m code for additional documentation)
%you should not need to alter this line, but you will
%need to write the robot_f, robot_Jac, and robot_constraint
%functions that are passed as arguments
[Qvec_expanded, Xvec_expanded, orig_inds] = Newton( @robot_f, Xvec, @robot_Jac, @robot_constraint, 1e-6, Qhome );