% 2.086, FALL 2011, for Pset 4 
% Not for Distribution

function animate_robot(W,T,v,steps_per_frame)

Xvec = v*T; Yvec = W(:,1);
dw1 = 4*0.0254; dw2 = 1.125*0.0254;
L1 = 4.2*0.0254; %m
L2 = 4.2*0.0254; %m

scrsz = get(0,'ScreenSize');
figure(50), clf
set(50,'Position',[scrsz(3)/8 scrsz(4)/8 scrsz(3)*3/4 scrsz(4)*3/4]);
plot(Xvec,Hgauss(Xvec))  
axis([min(Xvec)-L1-dw1/2 max(Xvec)+L2+dw2/2 0 max(Yvec)+0.2])
xlabel('x (m)')
ylabel('y (m)')
for i = 1:steps_per_frame:size(W,2)
    X = v*T(i);
    Y = W(1,i); theta = W(3,i);
    clf
    hold on
    plot(Xvec,Hgauss(Xvec))   
    
    X1 = X-L1*cos(theta);
    X2 = X+L2*cos(theta);
    Y1 = Y-L1*sin(theta);
    Y2 = Y+L2*sin(theta);

    h1 = Hgauss(X1);
    h2 = Hgauss(X2);

    Y1offset = Y1+dw1; Y2offset = Y2+dw1;
    line([X1 X2],[Y1offset Y2offset]);
    circle([X1 max(dw1/2+h1,Y1+dw1/2)],dw1/2,100);
    circle([X2 max(dw2/2+h2,Y2+dw2/2)],dw2/2,100);
    
    axis equal
    axis([min(Xvec)-L1-dw1/2 max(Xvec)+L2+dw2/2 0 max(Yvec)+0.2])
    xlabel('x (m)')
    ylabel('y (m)')
    drawnow
end
end

function H=circle(center,radius,NOP,style)
%---------------------------------------------------------------------------------------------
% H=CIRCLE(CENTER,RADIUS,NOP,STYLE)
% This routine draws a circle with center defined as
% a vector CENTER, radius as a scaler RADIS. NOP is 
% the number of points on the circle. As to STYLE,
% use it the same way as you use the rountine PLOT.
% Since the handle of the object is returned, you
% use routine SET to get the best result.
%
%   Usage Examples,
%
%   circle([1,3],3,1000,':'); 
%   circle([2,4],2,1000,'--');
%
%   Zhenhai Wang <zhenhai@ieee.org>
%   Version 1.00
%   December, 2002
%---------------------------------------------------------------------------------------------

if (nargin <3),
 error('Please see help for INPUT DATA.');
elseif (nargin==3)
    style='b-';
end;
THETA=linspace(0,2*pi,NOP);
RHO=ones(1,NOP)*radius;
[X,Y] = pol2cart(THETA,RHO);
X=X+center(1);
Y=Y+center(2);
H=plot(X,Y,style);
axis square;
end