%Calculates and returns Y_exact and theta_exact based on the exact, 
%analytical Equation 7 of Pset 4 and for the initial conditions of 
%Questions 5 and 9. Requires proper initialization of constants 
%k1, c1, L1, m, and g. Requires vector of times T.

%begin script
Y0 = 0; Y0dot = 0; theta0 = 0.1; theta0dot = 0;
k = k1; c = c1; L = L1;
Yeq = -m*g/(2*k);
thetaeq = 0;
betaY = c/m;
w0Y = sqrt(2*k/m);
wdY = sqrt(w0Y^2-betaY^2);
betatheta = c*L^2/Izz;
w0theta = sqrt(2*k*L^2/Izz);
wdtheta = sqrt(w0theta^2-betatheta^2);
Y_exact = Yeq+exp(-betaY*T).*((Y0-Yeq)*cos(wdY*T)+...
    ((betaY*(Y0-Yeq)+Y0dot)/wdY)*sin(wdY*T));
theta_exact = thetaeq+exp(-betatheta*T).*((theta0-thetaeq)*cos(wdtheta*T)+...
    ((betatheta*(theta0-thetaeq)+theta0dot)/wdtheta)*sin(wdtheta*T));
%end script