function [xlocal, ylocal] =localize(xpan,ypan,xglob,yglob);
% This function gives the local coordinates of (xglob,yglob) with respect
% to a panel where the panel is trhe local x axis and the y axis is to the
%left when going from the first point to the second of the panel. 
alpha = atan2(-ypan(2)+ ypan(1), xpan(2)-xpan(1));
xlocal=(xglob-0.5 * (xpan(2)+xpan(1))) * cos(alpha)- ...
    (yglob-0.5*(ypan(1) + ypan(2)))*sin(alpha);
ylocal = (xglob - 0.5*(xpan(1)+xpan(2)))*sin(alpha)+ ...
    (yglob- 0.5 * (ypan(1) + ypan(2)))*cos(alpha);