#!/bin/bash -f
#############################################################################
#$ -N gulp_test
#$ -cwd
#$ -o $HOME/LAB4/err.out
#$ -j y
#$ -S /bin/sh

########################################################
# This is a script to run GULP calculations in
# the hpcbeo2 cluster.
# P. Sit and N. Miller, 04-03-2005
########################################################
# set the needed variables

MYDIR="LAB4"
USER=`whoami`
RUNDIR="/state/partition1/$USER"

OUTPUT="/$HOME/$MYDIR"
if [ ! -d $RUNDIR ]; then
	mkdir $RUNDIR
fi

if [ ! -d $OUTPUT ]; then
        echo $MYDIR does not exist, please create it first
	exit
fi

#########################################################
# calculations

cd $RUNDIR

cell=3
integrator=leapfrog
integrator2=verlet
for timestep in 0.005
do
cat>gulp.wrap<<EOF
3.524 Ni
md conv
timestep $timestep
temperature 300
equilibration 3.50
production 3.50
integrator $integrator $integrator2
species
Ni core  0.000
manybody
Ni core Ni core 0.0 12.0
#attractive part
eam_density power 6
Ni core   729.6928296
#repulsive part  second power is a dummy argument
lennard 9 6
Ni core Ni core 1303.09841 0.0 0.0 12.0
EOF

echo $cell $cell $cell | /home/nedward/LAB4/bin/buildcell
/home/nedward/LAB4/bin/gulp < gulp.in > $OUTPUT/gulp.$cell.$integrator.$timestep.out
done                                                                                                                          
mv * $OUTPUT/ 
