#!/bin/bash -f
#############################################################################
#$ -N moldy_test
#$ -cwd
#$ -o $HOME/LAB4/test/err.out
#$ -j y
#$ -S /bin/sh

########################################################
# This is a script to run moldy calculations in
# the hpcbeo2 cluster.
# N. Miller and 03-07-2005
########################################################
# set the needed variables

MYDIR="LAB4/test"
INPUT_FILE="Kr.in"
USER=`whoami`

RUNDIR="/state/partition1/$USER"
OUTPUT="$HOME/$MYDIR"

if [ ! -d $RUNDIR ]; then
	mkdir $RUNDIR
fi

if [ ! -d $OUTPUT ]; then
        echo $MYDIR does not exist, please create it first
	exit
fi

#########################################################
# calculations
# oldtemp=10
cp $OUTPUT/$INPUT_FILE $RUNDIR/
cd $RUNDIR
#cp $OUTPUT/Kr.restart.oldtemp $RUNDIR/
for tstep in 0.001
do
for temp in 100
do

cat > $RUNDIR/control.Kr << EOF
title=KR
sys-spec-file=Kr.in

# TIME-TIMESTEP (picoseconds)
step=$tstep
nsteps=5000

# AVERAGES
begin-average=500
average-interval=100

# Temperature
temperature=$temp
scale-interval=200
scale-end=500
scale-options=4
#const-temp=1

# Pressure
#const-pressure=1
#w=1000.0
#pressure=0.
#strain-mask=238

# INITIAL CONDITION
lattice-start=1

# DUMP-RESTART
begin-dump=1001
dump-interval=50
dump-level=3
ndumps=100
dump-file=Krdump.$temp
#restart-file = Kr.restart.$oldtemp
save-file= Kr.restart.$temp
backup-file=

# Output
page-length=44
page-width=80
print-interval=200
roll-interval=200

# RDF
rdf-interval=20
begin-rdf=2000
rdf-limit=10.0
nbins=200
rdf-out=2500

# CUTOFF
cutoff=10
strict-cutoff=1

end
EOF

/home/nedward/LAB4/bin/moldy<control.Kr>$OUTPUT/Kr.$tstep.out.$temp
#oldtemp=$temp
done
done
mv $RUNDIR/*Kr* $OUTPUT/ 

