package monte;
/*
 * 
 * Created on Apr 19, 2005
 * by ccfisch
 */

import java.io.*;
import cern.colt.corejava.*;

/**
 * prints output data from MC runs, summary data, and configuration files
 * @author ccfisch
 * Date: Apr 24, 2005
 *
 */
public class DataPrinter {

    public static char nl=System.getProperty("line.separator").toCharArray()[0];
    protected double m_temp;
    protected double m_chem_pot;
    protected FileWriter m_fw;
    protected InputReader m_in;

    public DataPrinter(MCData[] data, double temp_or_mu, InputReader params,boolean temp_loop){
        m_in=params;
        try{            
            this.printSummary(data,temp_or_mu,temp_loop);
        }catch (IOException e){
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        
    }
    
    /**
     * Dump the output of a MC trajectory
     * @param data
     * @param params
     */
    public DataPrinter(MCData data, double temp, double mu, InputReader params){
        m_in=params;
        try{
            this.dumpData(data,temp,mu);
        }catch(IOException e){
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
   
    /**
     * print the config at a specific T and MU
     * @param config
     * @param temp
     * @param mu
     * @param params
     */
    public DataPrinter(int[][] config, double temp, double mu, InputReader params){
        m_in=params;
        try{
            this.printConfig(config,temp,mu);
        }catch(IOException e){
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
    
    /**
     * MCData should have all the data...
     * @param m
     * @param t
     * @param mu
     */
    private void dumpData(MCData m, double t, double mu) throws IOException{
        PrintfFormat fileF = new PrintfFormat("%07.4f");
        this.openFile("dataDump_"+fileF.sprintf(t)+"_"+fileF.sprintf(mu));
        m_fw.write("# system size: "+m_in.m_SIZE+nl);
        m_fw.write("#         T  : "+t+nl);
        m_fw.write("#         MU : "+mu+nl);
        m_fw.write(m.getDataDumpHeader());
        String[] allstr = m.getDataDump();
        for(int i=0; i<allstr.length; i++)
            m_fw.write(allstr[i]);
        
        this.closeFile();
        
    }
    
    private void openFile(String filename) throws IOException{
        this.m_fw=new FileWriter(filename);
    }
    
    private void closeFile() throws IOException{
        this.m_fw.close();
    }
    
    private void printConfig(int[][] config, double temp, double mu) throws IOException{
        PrintfFormat fileF = new PrintfFormat("%07.4f");
        this.openFile("config_"+fileF.sprintf(temp)+"_"+fileF.sprintf(mu));
        PrintfFormat spinF = new PrintfFormat("%3d");
        m_fw.write("# system size: "+m_in.m_SIZE+nl);
        m_fw.write("#        T   : "+temp+nl);
        m_fw.write("#        MU  : "+mu+nl);
        for(int i=0; i<config.length; i++){
            for(int j=0; j<config[i].length; j++){
                m_fw.write(spinF.sprintf(config[i][j]));
            }
            m_fw.write(nl);
        }
        this.closeFile();
    }
        
    private void printSummary(MCData[] data, double const_param, boolean temp_loop) throws IOException{
        PrintfFormat fileF = new PrintfFormat("%07.4f");
        if(temp_loop){
            this.openFile("chempot_const_"+fileF.sprintf(const_param));
        }else{
            this.openFile("temp_const_"+fileF.sprintf(const_param));
        }
        //char nl = '\n';
        int SIZE = m_in.m_SIZE;
        this.m_fw.write("# system size: "+m_in.m_SIZE+nl);
        this.m_fw.write("#          V1: "+m_in.m_V1+nl);
        this.m_fw.write("#          V2: "+m_in.m_V2+nl);
        this.m_fw.write("# equil. pass: "+m_in.m_NUM_EQ+nl);
        this.m_fw.write("#    num pass: "+m_in.m_NUM_PASS+nl);
        this.m_fw.write(data[0].getSummaryHeader());
        PrintfFormat pf = new PrintfFormat("%14.8f");
        for(int i=0; i<data.length; i++){
            m_fw.write(data[i].getSummary());
        }
        this.closeFile();
    }
    
}
