package monte;
/*
 * 
 * Created on Apr 18, 2005
 * by ccfisch
 */
import cern.colt.corejava.*;


/**
 * this class is just a wrapper for the relevant output of a monte carlo trajectory (MCSample)
 * 
 * kind of brutish, but works...
 * 
 * @author ccfisch
 * Date: Apr 22, 2005
 *
 */
public class MCData {

    public int[][] m_config;
    public double m_avgE;
    public double m_avgE2;
    public double m_avgS;
    public double m_avgAbsS;
    public double m_avgS2;
    public double m_T;
    public double m_MU;
    public double m_avgnn1;
    public double m_avgnn2;
    public double[] m_allE;
    public double[] m_allS;
    public double[] m_allNN1;
    public double[] m_allNN2;
    public double m_flip_freq;
    
    /**
     * Use if you want to print out raw data samples...
     * @param end_config
     * @param energy_vals
     * @param avg_spins
     */
    public MCData(int[][] end_config, double[] energy_perSite_vals, double[] spin_perSite, 
            double[] all_nn1,double[] all_nn2, double temp, double mu, double flip_freq){
        m_config=end_config;
        m_allE=energy_perSite_vals;
        m_allS=spin_perSite;
        m_allNN1=all_nn1;
        m_allNN2=all_nn2;
        m_T=temp;
        m_MU=mu;
        m_flip_freq=flip_freq;
        this.detAverages();
    }
    
    /**
     * use if one is just keeping around average quantities....
     * @param end_config
     * @param avg_energy_per_site
     * @param avg_sq_energy_ps
     * @param avg_spin
     * @param sq_avg_spin
     */
    public MCData(int[][] end_config, double avg_energy_per_site, double avg_sq_energy_ps,
                double avg_spin, double sq_avg_spin, double nn1_avg, double nn2_avg, 
                double temp, double mu, double flip_freq, double avgAbsS){
        m_config=end_config;
        m_avgE=avg_energy_per_site;
        m_avgE2=avg_sq_energy_ps;
        m_avgS=avg_spin;
        m_avgS2=sq_avg_spin;
        m_T=temp;
        m_MU=mu;
        m_avgnn1=nn1_avg;
        m_avgnn2=nn2_avg;
        m_flip_freq=flip_freq;
        m_avgAbsS=avgAbsS;
    }
    
    public String getSummaryHeader(){
        return new String("#       T            mu           <E>          <sigma>       <nn1>/4"+
                          "       <nn2>/4       Cv         (<M^2>-<M>^2)/(NkT)   (<M^2>-<|M|>^2)/(NkT)    flip_freq"+DataPrinter.nl);
    }
    
    /**
     * get summary of the sampling run
     * @return
     */
    public String getSummary(){
        String n = new String();
        PrintfFormat dv = new PrintfFormat("%14.8f");
        n+=dv.sprintf(m_T);
        n+=dv.sprintf(m_MU);
        n+=dv.sprintf(m_avgE);
        n+=dv.sprintf(m_avgS);
        n+=dv.sprintf(m_avgnn1);
        n+=dv.sprintf(m_avgnn2);
        n+=dv.sprintf((m_avgE2-(m_config.length*m_config.length)*m_avgE*m_avgE)/(m_T*m_T));
        n+=dv.sprintf((m_avgS2-(m_config.length*m_config.length)*m_avgS*m_avgS)/m_T);
        n+=dv.sprintf((m_avgS2-(m_config.length*m_config.length)*m_avgAbsS*m_avgAbsS)/m_T);
        n+=dv.sprintf(m_flip_freq);
        n+=DataPrinter.nl;
        return n;
    }
    
    /**
     * column format of data dump
     * @return
     */
    public String getDataDumpHeader(){
        return new String("# energy/N      spin/N         NN1/(4*N)      NN2/(4*N)"+DataPrinter.nl);
    }
    
    /**
     * returns an array of strings {"energy spin nn1 nn2", "energy spin nn1 nn2",...}
     * @return
     */
    public String[] getDataDump(){
        PrintfFormat dv = new PrintfFormat("%14.8f");
        if(m_allE==null){
            return new String[0];
        }
        String[] allstr = new String[m_allE.length];
        for(int i=0; i<m_allE.length; i++){
            allstr[i]=dv.sprintf(m_allE[i])+dv.sprintf(m_allS[i])+
                      dv.sprintf(m_allNN1[i])+dv.sprintf(m_allNN2[i])+DataPrinter.nl;
        }
        return allstr;
    }
    
    /**
     * clear all of the data arrays. i.e. reduces memory req'mnt
     * when the garbage collector is run..
     */
    public void clearArrays(){
        if(this.m_allE!=null){
            m_allE=null;
            m_allS=null;
            m_allNN1=null;
            m_allNN2=null;
        }
    }
    
    public void detAverages(){
        int length = this.m_allE.length;
        int nsites = this.m_config.length*m_config.length;
        for(int i=0; i<length; i++){
            this.m_avgE+=m_allE[i];
            this.m_avgE2+=m_allE[i]*m_allE[i]*nsites; //the formula used in Cv req <E^2>/N
            this.m_avgS+=m_allS[i];
            this.m_avgAbsS+=(m_allS[i]>0) ? m_allS[i] : -1.0*m_allS[i];
            this.m_avgS2+=m_allS[i]*m_allS[i]*nsites; //same for susceptibility
            this.m_avgnn1+=m_allNN1[i];
            this.m_avgnn2+=m_allNN2[i];
        }
        m_avgE/=length;
        m_avgS/=length;
        m_avgE2/=length;
        m_avgS2/=length;
        m_avgAbsS/=length;
        m_avgnn1/=length;
        m_avgnn2/=length;
    }
}
