#!/bin/bash -f
#############################################################################
#$ -N BaTiO3
#$ -cwd
#$ -o $HOME/3.320/LAB3/TEST/err.out
#$ -j y
#$ -S /bin/sh

########################################################
# This is a script to run PWSCF 2.1.2 calculations in
# the hpcbeo2 cluster.
#
# This script will relax the oxygen and titanium atoms of BaTiO3
# to find the stablest tetragonal phase 
########################################################
# set the needed variables

MYDIR="3.320/LAB3/TEST"

LISTA='7.52'

USER=`whoami`

OUTDIR="/state/partition1/$USER"
PSEUDO_DIR="/home/brandonw/LAB3"
OUTPUT="/home/$USER/$MYDIR"
PREFIX="BaTiO3.distortTiO"

if [ ! -d $OUTDIR ]; then
	mkdir $OUTDIR
fi

if [ ! -d $OUTPUT ]; then
        echo $MYDIR does not exist, please create it first
	exit
fi

rm -f $OUTDIR/$PREFIX.*
#########################################################
# calculations

for a in $LISTA
do

INFILE="$PREFIX.in"
OUTFILE="$PREFIX.out"
rm -f $OUTPUT/$INFILE
rm -f $OUTPUT/$OUTFILE

cat > $OUTPUT/$INFILE << EOF
 &control
    calculation = 'relax',
    restart_mode = 'from_scratch',
    prefix = '$PREFIX',
    tstress = .true.,
    tprnfor = .true.,
    pseudo_dir = '$PSEUDO_DIR',
    outdir='$OUTDIR'
 /
 &system
    ibrav =  1, 
    celldm(1) = $a, 
    nat =  5, 
    ntyp = 3,
    ecutwfc = 30.0,
    ecutrho = 240.0
 /
 &electrons
    diagonalization='cg',
    mixing_mode = 'plain',
    mixing_beta = 0.7,
    conv_thr =  1.0d-8
 /
 &ions
    ion_dynamics='bfgs'
 /

ATOMIC_SPECIES
 Ba 137.327 Ba.UPF
 Ti 47.88   Ti.UPF
 O  15.9994 O.UPF

ATOMIC_POSITIONS
 Ba 0.0 0.0 0.0 0 0 0
 Ti 0.5 0.5 0.515 
 O 0.5 0.5 0
 O 0.5 0.0 0.5
 O 0.0 0.5 0.5

K_POINTS automatic
  4 4 4 1 1 1
EOF

/home/brandonw/LAB3/pw.x < $OUTPUT/$INFILE > $OUTPUT/$OUTFILE

done

rm -f $OUTDIR/$PREFIX.*  
