#!/bin/bash -f
#############################################################################
#$ -N Co.HCP.scf
#$ -cwd
#$ -o $HOME/3.320/LAB3/TEST/err.out
#$ -j y
#$ -S /bin/sh

########################################################
# This is a script to run PWSCF 2.1.2 calculations in
# the hpcbeo2 cluster.
# 
# This script will help you to construct different 
# stacking sequence in hexagonal structure of Co.
########################################################
# set the needed variables

MYDIR="3.320/LAB3/TEST"

USER=`whoami`

OUTDIR="/state/partition1/$USER"
PSEUDO_DIR="/home/lee0su/3.320"
OUTPUT="/home/$USER/$MYDIR"
PSEUDOFILE="Co.pz-nd-rrkjus.UPF"

if [ ! -d $OUTDIR ]; then
	mkdir $OUTDIR
fi

if [ ! -d $OUTPUT ]; then
        echo $MYDIR does not exist, please create it first
	exit
fi

#########################################################
# calculations

ecutrho='250'
ecutwfc='30'
ak='8'
a='4.58'
unitc='3.719'

POSA='0.3333333333  0.6666666667'
POSB='0.6666666667  0.3333333333'
POSC='0.0000000000  0.0000000000'

for nlayer in 17  

do

PREFIX="Co.$nlayer.stacking"
rm -f $OUTDIR/$PREFIX.*

let "ck = 24 / $nlayer"

c=`awk "BEGIN {printf \" %15.10f \", $unitc*$nlayer/$a}"`

i=0

while [ $i -lt $nlayer ]

do

crd=`awk "BEGIN {printf \" %15.10f \", $i/$nlayer}"`

let "j = $i % 2"
 
if [ $i -eq 0 ] ; then

cat > $OUTPUT/crd.$nlayer.txt << EOF
Co  $POSA   $crd
EOF

elif [ $i -eq 1 ] ; then

cat >> $OUTPUT/crd.$nlayer.txt << EOF
Co  $POSB   $crd
EOF

elif [ $j -eq 0 ] ; then

cat >> $OUTPUT/crd.$nlayer.txt << EOF
Co  $POSC   $crd
EOF

else

cat >> $OUTPUT/crd.$nlayer.txt << EOF
Co  $POSA   $crd
EOF

fi

let "i += 1"

done

INFILE="$PREFIX.in"
OUTFILE="$PREFIX.out"

rm -f $OUTPUT/$INFILE
rm -f $OUTPUT/$OUTFILE


cat > $OUTPUT/$INFILE << EOF
 &control
    calculation = 'scf'
    restart_mode='from_scratch'
    prefix='$PREFIX'
    tstress = .true.
    tprnfor = .true.
    outdir = '$OUTDIR'
    pseudo_dir = '$PSEUDO_DIR'
 /        
 &system    
    ibrav=  4
    celldm(1) = $a
    celldm(3) = $c
    nat=  $nlayer
    ntyp= 1
    ecutwfc = $ecutwfc 
    ecutrho = $ecutrho
    starting_magnetization(1) = 0.3
    occupations = 'smearing'
    degauss = 0.03
    smearing = 'cold'
    nspin = 2
 /
 &electrons
    mixing_beta = 0.1
    conv_thr =  1.0d-6
    electron_maxstep = 300
 /
 ATOMIC_SPECIES
  Co  58.933  $PSEUDOFILE
 ATOMIC_POSITIONS (crystal)
EOF

cat $OUTPUT/crd.$nlayer.txt >> $OUTPUT/$INFILE

cat >> $OUTPUT/$INFILE << EOF
 K_POINTS {automatic}
    $ak $ak $ck 0 0 0 
EOF

/home/lee0su/3.320/pw.x < $OUTPUT/$INFILE > $OUTPUT/$OUTFILE

done

rm -f $OUTDIR/$PREFIX.*  
