#!/bin/bash -f
#############################################################################
#$ -N Co.FCC.scf
#$ -cwd
#$ -o $HOME/3.320/LAB3/TEST/err.out
#$ -j y
#$ -S /bin/sh

########################################################
# This is a script to run PWSCF 2.1.2 calculations in
# the hpcbeo2 cluster.
# 
# This script will help you to get equilibrium lattice 
# parameter of FCC Co.
########################################################
# set the needed variables

MYDIR="3.320/LAB3/TEST"

LISTECUTRHO='250'
LISTECUTWFC='30'
LISTK='12'
LISTA='6.48'

USER=`whoami`

OUTDIR="/state/partition1/$USER"
PSEUDO_DIR="/home/lee0su/3.320"
OUTPUT="/home/$USER/$MYDIR"
PSEUDOFILE="Co.pz-nd-rrkjus.UPF"
PREFIX="Co.FCC"

if [ ! -d $OUTDIR ]; then
	mkdir $OUTDIR
fi

if [ ! -d $OUTPUT ]; then
        echo $MYDIR does not exist, please create it first
	exit
fi

rm -f $OUTDIR/$PREFIX.*
#########################################################
# calculations

for ecutrho in $LISTECUTRHO
do
for ecutwfc in $LISTECUTWFC
do
for k in $LISTK
do
for a in $LISTA
do

INFILE="$PREFIX.scf.$a.$ecutwfc.$ecutrho.$k.in"
OUTFILE="$PREFIX.scf.$a.$ecutwfc.$ecutrho.$k.out"
rm -f $OUTPUT/$INFILE
rm -f $OUTPUT/$OUTFILE


cat > $OUTPUT/$INFILE << EOF
 &control
    calculation = 'scf'
    restart_mode='from_scratch'
    prefix='$PREFIX'
    tstress = .true.
    tprnfor = .true.
    outdir = '$OUTDIR'
    pseudo_dir = '$PSEUDO_DIR'
 /        
 &system    
    ibrav=  2
    celldm(1) = $a
    nat=  1
    ntyp= 1
    ecutwfc = $ecutwfc 
    ecutrho = $ecutrho
    starting_magnetization(1) = 0.7
    occupations = 'smearing'
    degauss = 0.03
    smearing = 'cold'
    nspin = 2
 /
 &electrons
    mixing_beta = 0.7 
    conv_thr =  1.0d-8
 /
 ATOMIC_SPECIES
  Co  58.933  $PSEUDOFILE
 ATOMIC_POSITIONS
  Co 0.00 0.00 0.00 
 K_POINTS {automatic}
    $k $k $k 0 0 0 
EOF

/home/lee0su/3.320/pw.x < $OUTPUT/$INFILE > $OUTPUT/$OUTFILE

done
done
done
done

rm -f $OUTDIR/$PREFIX.*  
