#!/bin/bash
#

ecutwfc='30'
ecutrho='250'
k='12'
nump=14
ain='5.60'
interval='0.10'
SUMFILE="msum.FCC"

rm -f $SUMFILE
touch $SUMFILE

PREFIX="Co.FCC"

n=0

while [ $n -lt $nump ]
do

a=`awk "BEGIN {printf \"%4.2f\",$ain+$n*$interval}"`
OUTFILE="$PREFIX.scf.$a.$ecutwfc.$ecutrho.$k.out"
etot=`grep ! $OUTFILE | gawk '{print $5}'`
totm=`grep -B 3 "convergence has been" $OUTFILE | gawk 'NR==1 {print $4}'`
pressure=`grep "P=" $OUTFILE | gawk '{print $6}'`

cat >> $SUMFILE << EOF
$a   $etot   $totm   $pressure
EOF

let "n += 1"

done

