# we have to send valid HTTP headers back to the browser
# before we can write user-visible stuff
# ReturnHeaders is our own procedure, defined in
# /home/nsadmin/modules/tcl/utilities.tcl 

ReturnHeaders

ns_write "
<html>
<head>
<title>A simple Tcl page</title>
</head>
<body>

<h2>A Simple Tcl Page</h2>

<hr>

Here is some static text that we are able to show the user before we
go off and do anything fancy that might involve database or
computation delays.  By doing this in an ns_write and streaming it
out, the user does not have to look at a blank screen.

<p>

One of the disadvantages of .tcl pages is that you have to remember to
backslash your double quote characters: \"

<p>

Now we're going to perform a few simple computations:

<ul>

"

# we call the AOLserver API call ns_conn (documented at 
# http://www.aolserver.com in the Tcl Developer's Guide)

set client_ip_address [ns_conn peeraddr]

ns_write "<li>You are connecting from $client_ip_address"

set client_hostname [ns_hostbyaddr $client_ip_address]

# empty_string_p is defined in utilities.tcl

if ![empty_string_p $client_hostname] {
    ns_write " ($client_hostname)"
}

set server_name [ns_info server]

ns_write "<li>You are using the $server_name server"

# an example of calling a procedure from within a string

ns_write ", which is rooted at [ns_info pageroot]."

# close the unordered list; note the use of \n for newline these
# aren't significant for an HTML parser but they make the structure
# clearer for a human who is doing a View Source on a page

ns_write "\n</ul>\n"

ns_write "
<h3>Our First Form</h3>

<form method=GET action=\"simple-tcl-page-2.tcl\">

Please tell us your name:
<input type=text size=30 name=full_name>

<p>

Please tell us your quest:
<input type=text size=30 name=quest>

<p>

Please tell us your favorite color:
<select name=favorite_color>
<option value=blue>Blue
<option value=red>No, Red!
<option value=purple>Purple
</select>


<p>

<center>
<input type=submit>
</center>
</form>
"

# let's close up the page and make sure to take ownership at
# the bottom

ns_write "
<hr>
<address>god@heaven.com</address>
</body>
</html>
"