open Implang;;
open Hashtbl;; 

type cfg_node = BasicBlock of bb_content 
		| Split of split_content 
		| End
and
bb_content = {bid : int; content : stmt list ; next : cfg_node ref}
and
split_content = {sid : int; cond : expr ; tcase: cfg_node ref ; fcase: cfg_node ref };;


let getId node = 
	match node with
	| BasicBlock bb -> bb.bid
	| Split sc -> sc.sid
	| End -> -1
;;

let rec addStmt s = 
	match s with
	| Skip -> ([], s)
	| Seq(s1, s2) -> let (lst1, nxt1) =  addStmt s1 
                         in if(nxt1 == Skip) then
                             let (lst2, nxt2) = addStmt (s2)  
			     in                              
                             ((List.concat [lst1; lst2]) , nxt2) 
                          else
                             (lst1, Seq(nxt1, s2))

	| Ifthen(e,st,sf) -> ([], s) 
	| Whileloop(c,inv,body) -> ([], s)
	| _  -> ([s], Skip)
;;

let rec clstToStr  lst = 
	match lst with
	| [] -> ""
	| a::b -> ( (stmtToStr a) ^ (clstToStr b))
;;

let rec buildCFG (s: stmt) (start : int) : (cfg_node * cfg_node * int) = 
   let (lst, leftover) = addStmt s
    in     
    match leftover with
      | Skip -> let x= BasicBlock({bid = start; content=lst; next= ref End}) 
                 in (x , x, start + 1)
      | Ifthen(c,lft,rght) -> 
                let (lftStart, BasicBlock(lftEnd), lend) = buildCFG lft (start+1)
	         in let (rghtStart, BasicBlock(rghtEnd), rend) = buildCFG rght lend
	         in let split = Split({sid=start; cond=c;
			        	tcase =ref lftStart; fcase= ref rghtStart})
		 in let join = BasicBlock{bid=rend; content=[]; next=ref End}
		 in
		    lftEnd.next := join;
		    rghtEnd.next := join;
		    (split, join, rend+1)		
      | Whileloop(c,inv,body) -> 
                let (bodyStart, BasicBlock(bodyEnd), bend) = buildCFG body (start + 1)
                 in let exit = BasicBlock{bid=bend; content=[]; next=ref End}  
		 in let split = Split({sid = start; cond=c; 
					tcase=ref bodyStart;
					fcase=ref exit })
				in bodyEnd.next := split ; (split, exit, bend+1)
     | Seq(fst, snd) ->
		    let rec foo s1 s2 = 
		    (	match s1 with 
			| Seq(s11, s12) -> 
			  foo s11 (Seq(s12, s2))
		 	| _ -> 		 
                          let (fstStart, BasicBlock(fstEnd), fstCnt) =  buildCFG s1 (start +1) 
		          in let x= BasicBlock({bid = start; content=lst; next= ref fstStart})
			  in let (sndStart, sndEnd, sndCnt) =  buildCFG s2 fstCnt 
			  in fstEnd.next := sndStart; 
			  (x, sndEnd, sndCnt) )
		     in (foo fst snd)
     | _ -> (End, End, -1)
;;


let printCFGNode entry prev = 
	match entry with
	| BasicBlock bb -> prev ^ ((string_of_int bb.bid ) ^ ": BB "  ^ "\n-----\n" ^ 
			        (clstToStr bb.content) ^ "-----> (" ^ (string_of_int (getId !(bb.next)) ) ^ ")\n"  )  
	| Split sb -> prev ^ (string_of_int sb.sid )^ ": Split --> (" ^ 
		(string_of_int(getId !(sb.tcase))) ^ ", " ^ (string_of_int(getId !(sb.fcase))) 
                ^ ") \n"
	| End -> prev ^ "/*END*/"
;;

let rec traverseCFG entry f state= 
	match entry with
	| BasicBlock bb -> let t = (f entry state)  in
	(	match !(bb.next) with
		| BasicBlock next ->if(next.bid == bb.bid + 1) then traverseCFG !(bb.next) f t else t
		| Split next -> if(next.sid == bb.bid + 1) then traverseCFG !(bb.next) f t else t  
		| End -> traverseCFG !(bb.next) f t )
	| Split sb ->   (traverseCFG  !(sb.fcase) f  (traverseCFG !(sb.tcase) f (f entry state)) ) 		
	| End -> (f entry state)
;;

let rec printCFG entry = 
	traverseCFG entry printCFGNode ""
;;



module IntMap = Map.Make(struct type t = int let compare = compare end);;

let printState state abs_state_to_string = 	
	let helper id lstate sofar = 
		(IntMap.add id ("NODE " ^ (string_of_int id) ^ ": \n" ^ (abs_state_to_string lstate)) sofar)
  in
	let helper2 id text sofar = 
		(sofar ^ text)
	in
		(IntMap.fold  helper2 (Hashtbl.fold helper state IntMap.empty) "")
;;				

let rec cfgToList start = 
	let rec helper s rest =
	match s with
	| BasicBlock bb -> ( match !(bb.next) with 
											| BasicBlock next -> if(next.bid == bb.bid + 1) then  s :: (helper !(bb.next) rest) else s :: rest
											| Split next -> if(next.sid == bb.bid + 1) then  s :: (helper !(bb.next) rest) else s :: rest 
											| End -> s :: (helper !(bb.next) rest) )
	| Split sb -> s :: (helper !(sb.tcase) (helper !(sb.fcase) rest))
	| End -> s :: rest
  in helper start []
;;


let rec abstractInterp stateTable cfg transfer stateEq merge bottom = 
	let myfind idx = 
		if(Hashtbl.mem stateTable idx) then (Hashtbl.find stateTable idx ) else ((Hashtbl.add stateTable idx bottom) ; bottom)		
	in
	let myAdd idx aval = 
		(Hashtbl.replace stateTable idx aval)
	in		
	let rec helper nextlist = 
		match nextlist with
		| [] -> stateTable
		| a::b -> match a with 
							| BasicBlock bb -> let start = (myfind bb.bid) in
		          									 let newEnd = transfer a start !(bb.next) in
																 let nextId = (getId !(bb.next)) in
																 let oldEnd =  (myfind nextId ) in																 
																 if (stateEq oldEnd newEnd) then
																	  (helper b) 
																 else
																	  ( (myAdd nextId (merge oldEnd newEnd)); 
																		  (helper (b @ [!(bb.next)])) )
																	  
						  | Split sb -> let start = (myfind sb.sid) in
							  						let newEndT =  transfer a start !(sb.tcase) in
														let newEndF =  transfer a start !(sb.fcase) in
														let nextIdT = (getId !(sb.tcase)) in
														let nextIdF = (getId !(sb.fcase)) in
														let oldEndT =  myfind nextIdT in
														let oldEndF =  myfind nextIdF in
														helper (
  														if (stateEq oldEndT newEndT) then
  															(
																if (stateEq oldEndF newEndF) then
  																 b
																else
																	 ((myAdd nextIdF (merge oldEndF newEndF)); 
																	 (b @ [!(sb.fcase)]))
																)
															else
																(
																(myAdd nextIdT (merge oldEndT newEndT));
																if (stateEq oldEndF newEndF) then
  																 (b @ [!(sb.tcase)])
																else
																	 ((myAdd nextIdF (merge oldEndF newEndF)); 
																		(b @ !(sb.tcase)::[!(sb.fcase)]))
															  )														
	 													)
							| End -> helper b
in helper (cfgToList cfg)
;;


