
open Implang;;
open Absint;;

let debug = false;;

let debugprint msg = 
	if debug then (print_string msg);;
	


module VarState = Map.Make(String);; 

type absVal = Const of int | Top | Bottom ;;

let lub (a:absVal) (b:absVal) = 
	match (a,b) with
	| (Const x, Const y) -> if(x==y) then a else Top
	| (Bottom, _) -> b
	| (_ , Bottom) -> a
	| _ -> Top
;;

type constPropAS = absVal VarState.t;;

let printCpropAS (st:constPropAS) = 
	let helper var av instr = 
		(instr ^ var ^ "->" ^ (match av with | Const(i) -> "Const" | Top -> "Top" | Bottom->"Bot") ^ ";")
  in 				
		(VarState.fold helper st "") ^"\n"
;;

let getAbsVal (state:constPropAS) (var:string) : absVal = 
	if ( VarState.mem var state) then
		(VarState.find var state)
	else
		(VarState.find "_ELSE" state);
;;




let rec absEval (e:expr) (input:constPropAS) = 
match e with 
	| Num(a) -> Const(a)
	| Var v -> getAbsVal input v
	| Unary( op, e ) -> Top
	| Binary(op, e1, e2) -> (let v1 = absEval e1 input in
													let v2 = absEval e2 input in
													match (v1, v2) with
													| (Const x, Const y) ->( match op with
																									| Plus -> Const (x + y) 
                                            			| Minus -> Const (x - y)
                                            			| Times -> Const (x * y)
																									| _ -> Top )
													| (Bottom , Bottom) -> Bottom
													| _ -> Top)
	| _ -> Top
;;

let stmtTransfer (input:constPropAS) (s:stmt) : constPropAS= 
	match s with 
	 | Skip -> input
   | Pre(e) -> input
	 | Post(e) -> input
	 | Assign(lhs, rhs) -> (VarState.add lhs (absEval rhs input) input)
	 | Malloc(lhs, size) ->  (VarState.add lhs Top input)
	 | _ -> input 
;;

let transfer (a:cfg_node) (input:constPropAS) (next:cfg_node) = 
	(debugprint ("Inside Transfer " ^ (string_of_int (getId a))^ " \n"));
	match a with
	| BasicBlock bb ->  List.fold_left stmtTransfer input bb.content
	| Split _ -> input
	| End -> input 
;;

let stateEq (u:constPropAS) (v:constPropAS) =
	(debugprint ("StateEq " ^ (printCpropAS u) ^ " with " ^ (printCpropAS v) ^ "\n") );
	let eq a b = match (a,b) with 
		| (Const x, Const y) -> x == y
		| (Top, Top) -> true
		| (Bottom, Bottom) -> true
		| _ -> false
  in VarState.equal eq u v
;; 


let merge (a:constPropAS) (b:constPropAS) =
	(debugprint ("Merging " ^ (printCpropAS a) ^ " with " ^ (printCpropAS b) ^ "\n") );
	let rec helperA key v cur = 
		if (VarState.mem key b) then
			(VarState.add key  (lub  v (VarState.find key b) ) cur)
		else
			(VarState.add key  (lub  v (VarState.find "_ELSE" b) ) cur)
	in 
	let rec helperB key v inm = 
		if (VarState.mem key inm) then
			inm
		else
			(VarState.add key  (lub  v (VarState.find "_ELSE" a) ) inm)
	in
	  VarState.fold helperB b (VarState.fold helperA a VarState.empty)
