
open Implang;;
open Absint;;
open Cprop;;

let lexbuf = Lexing.from_channel stdin ;;

let result = Parser.main Lexer.token lexbuf;;
(* print_string (stmtToStr result);; *)


(* Code builds the CFG. The CFG is not very clean, but for the purpose of the assignment it doens't matter *)
let (cfg, _, _)  = buildCFG result 0;;
print_string "******Printing CFG*****\n";;
print_string (printCFG cfg);;


(* The code below uses the abstract interpretation framework with the abstract domain from cprop.ml*)
(* Your job for this assignment will be to change this code so that instead of using cprop it uses*)
(* your own abstract domain that reasons about the heap. *)
let stateStore = Hashtbl.create 1024;; 

(* The abstract state maps each variable to an abstract value. "_ELSE" is used *)
(* to refer to any variables that we have not seen yet *)
let top = (VarState.add "_ELSE" Top VarState.empty);; 
let bottom = (VarState.add "_ELSE" Bottom VarState.empty);;

(*Initially, the state of the program input maps all variables to Top*)
(Hashtbl.add stateStore (getId cfg) (top));;


(*The function abstractInterp takes a state store mapping points in the CFG to abstract states,*)
(* together with a transfer function, a state equality comparison and a merge function *)
(* the last parameter is an abstract state corresponding to bottom*)

abstractInterp stateStore cfg transfer stateEq merge bottom;;
print_string "------Result --------\n";

print_string (printState stateStore printCpropAS);;

let printResult entry prev = 
	let rec stmtResult bid slist = 
	 match slist with
		  | [] -> ""
		  | a::rest -> (string_of_int bid) ^ ":" ^ (stmtToStr a) ^ "----" ^ "YES" ^ "\n" ^ (stmtResult bid rest)
	in
	match entry with
	| BasicBlock bb -> prev ^ (stmtResult bb.bid bb.content)   
	| _  -> prev  
;;

print_string (traverseCFG cfg printResult "");; 



