/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Panel;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCComboBox;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCMenu;
import jclass.bwt.JCMenuBar;
import jclass.bwt.JCSeparator;
import jclass.bwt.JCSlider;
import jclass.bwt.JCTextField;
import jclass.util.JCUtilConverter;
import org.nfunk.jep.IllegalExpressionException;

public class LagrangeMultipliersTwoVariables
extends Applet {
    static final double H = 1.0E-5;
    Panel titlePanel = new Panel();
    JCLabel fValueLabel = new JCLabel();
    JCLabel gValueLabel = new JCLabel();
    JCLabel gradfValueLabel = new JCLabel();
    JCLabel gradgValueLabel = new JCLabel();
    JCLabel posValueLabel = new JCLabel();
    Panel surfacePanel = new Panel();
    JCComboBox fxyComboBox = new JCComboBox();
    JCComboBox gxyComboBox = new JCComboBox();
    JCLabel JCLabel1 = new JCLabel();
    JCLabel label2 = new JCLabel();
    JCLabel JCLabel3 = new JCLabel();
    JCLabel JCLabel4 = new JCLabel();
    JCSlider aSlider = new JCSlider();
    JCLabel aSliderValueLabel = new JCLabel();
    JCSlider bSlider = new JCSlider();
    JCLabel bSliderValueLabel = new JCLabel();
    JCCheckbox showGradGCheckbox = new JCCheckbox();
    JCCheckbox showGradFCheckbox = new JCCheckbox();
    JCButton plotButton = new JCButton();
    JCCheckbox showSolutionsCheckbox = new JCCheckbox();
    JCLabel label1 = new JCLabel();
    JCLabel xMaxLabel = new JCLabel();
    JCTextField xMaxTextField = new JCTextField();
    JCTextField yMinTextField = new JCTextField();
    JCLabel yMaxLabel = new JCLabel();
    JCTextField yMaxTextField = new JCTextField();
    JCLabel xMinLabel = new JCLabel();
    JCLabel yMinLabel = new JCLabel();
    JCTextField xMinTextField = new JCTextField();
    JCSeparator JCSeparator1 = new JCSeparator();
    JCMenuBar menuBar = new JCMenuBar();
    JCMenu keysMenu = new JCMenu();
    Graph graph;
    MkComboBoxManager cbManager;
    MkKeysFrame keysFrame;

    public void init() {
        boolean bl = MkUtilities.menuFirst();
        if (bl) {
            this.layoutMenu();
        }
        this.setLayout(null);
        this.setBackground(new Color(0, 51, 102));
        this.setSize(760, 450);
        this.setVisible(false);
        this.titlePanel.setLayout(null);
        this.add(this.titlePanel);
        this.titlePanel.setForeground(Color.white);
        this.titlePanel.setBounds(385, 400, 370, 50);
        this.fValueLabel.setLabel((Object)"f = 1; ");
        this.fValueLabel.setAlignment(3);
        this.fValueLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.titlePanel.add((Component)this.fValueLabel);
        this.fValueLabel.setForeground(Color.cyan);
        this.fValueLabel.setFont(new Font("Dialog", 1, 12));
        this.fValueLabel.setBounds(150, 0, 70, 25);
        this.gValueLabel.setLabel((Object)"g = 2;");
        this.gValueLabel.setAlignment(3);
        this.gValueLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.titlePanel.add((Component)this.gValueLabel);
        this.gValueLabel.setForeground(Color.yellow);
        this.gValueLabel.setFont(new Font("Dialog", 1, 12));
        this.gValueLabel.setBounds(150, 25, 70, 25);
        this.gradfValueLabel.setLabel((Object)"grad f = <1, 2>");
        this.gradfValueLabel.setAlignment(3);
        this.gradfValueLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.titlePanel.add((Component)this.gradfValueLabel);
        this.gradfValueLabel.setForeground(Color.cyan);
        this.gradfValueLabel.setFont(new Font("Dialog", 1, 12));
        this.gradfValueLabel.setBounds(220, 0, 150, 25);
        this.gradgValueLabel.setLabel((Object)"grad g = <2, 2>");
        this.gradgValueLabel.setAlignment(3);
        this.gradgValueLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.titlePanel.add((Component)this.gradgValueLabel);
        this.gradgValueLabel.setForeground(Color.yellow);
        this.gradgValueLabel.setFont(new Font("Dialog", 1, 12));
        this.gradgValueLabel.setBounds(220, 25, 150, 25);
        this.posValueLabel.setLabel((Object)"At (x, y) = (1, 1):");
        this.posValueLabel.setAlignment(3);
        this.posValueLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.titlePanel.add((Component)this.posValueLabel);
        this.posValueLabel.setForeground(Color.magenta);
        this.posValueLabel.setFont(new Font("Dialog", 1, 12));
        this.posValueLabel.setBounds(0, 0, 150, 50);
        this.surfacePanel.setLayout(null);
        this.add(this.surfacePanel);
        this.surfacePanel.setBounds(5, 30, 370, 420);
        this.fxyComboBox.setItems(JCUtilConverter.toStringList((String)new String("x*y^2\nx^2-y^2\nx^2+y^2\nx-y\ny*x^2"), (char)'\n'));
        this.fxyComboBox.setText("x*y^2");
        this.surfacePanel.add((Component)this.fxyComboBox);
        this.fxyComboBox.setForeground(Color.cyan);
        this.fxyComboBox.setFont(new Font("Dialog", 1, 12));
        this.fxyComboBox.setBounds(85, 52, 200, 26);
        this.gxyComboBox.setItems(JCUtilConverter.toStringList((String)new String("x*y^2\nx^2-y^2\nx^2+y^2\nx-y\ny*x^2"), (char)'\n'));
        this.gxyComboBox.setText("x^2+y^2");
        this.surfacePanel.add((Component)this.gxyComboBox);
        this.gxyComboBox.setForeground(Color.yellow);
        this.gxyComboBox.setFont(new Font("Dialog", 1, 12));
        this.gxyComboBox.setBounds(85, 88, 200, 26);
        this.JCLabel1.setLabel((Object)" = a");
        this.JCLabel1.setAlignment(3);
        this.JCLabel1.setInsets(new Insets(-2, 0, 0, 0));
        this.surfacePanel.add((Component)this.JCLabel1);
        this.JCLabel1.setForeground(Color.cyan);
        this.JCLabel1.setFont(new Font("Dialog", 1, 12));
        this.JCLabel1.setBounds(298, 52, 64, 30);
        this.label2.setLabel((Object)"f(x, y) =");
        this.label2.setAlignment(3);
        this.label2.setInsets(new Insets(-2, 0, 0, 0));
        this.surfacePanel.add((Component)this.label2);
        this.label2.setForeground(Color.cyan);
        this.label2.setFont(new Font("Dialog", 1, 12));
        this.label2.setBounds(20, 52, 64, 30);
        this.JCLabel3.setLabel((Object)"g(x, y) =");
        this.JCLabel3.setAlignment(3);
        this.JCLabel3.setInsets(new Insets(-2, 0, 0, 0));
        this.surfacePanel.add((Component)this.JCLabel3);
        this.JCLabel3.setForeground(Color.yellow);
        this.JCLabel3.setFont(new Font("Dialog", 1, 12));
        this.JCLabel3.setBounds(19, 88, 64, 30);
        this.JCLabel4.setLabel((Object)" = b");
        this.JCLabel4.setAlignment(3);
        this.JCLabel4.setInsets(new Insets(-2, 0, 0, 0));
        this.surfacePanel.add((Component)this.JCLabel4);
        this.JCLabel4.setForeground(Color.yellow);
        this.JCLabel4.setFont(new Font("Dialog", 1, 12));
        this.JCLabel4.setBounds(298, 88, 64, 30);
        this.aSlider.setMinimumLabelString("-125");
        this.aSlider.setMaximumLabelString("125");
        this.aSlider.setUnitIncrement(1);
        this.aSlider.setValue(75);
        this.aSlider.setMaximum(101);
        this.aSlider.setNumTicks(20);
        this.aSlider.setBlockIncrement(1);
        this.surfacePanel.add((Component)this.aSlider);
        this.aSlider.setForeground(Color.cyan);
        this.aSlider.setFont(new Font("Dialog", 1, 12));
        this.aSlider.setBounds(10, 210, 350, 55);
        this.aSliderValueLabel.setLabel((Object)"a = 5");
        this.aSliderValueLabel.setAlignment(3);
        this.aSliderValueLabel.setInsets(new Insets(0, 0, 0, 0));
        this.aSlider.add((Component)this.aSliderValueLabel);
        this.aSliderValueLabel.setFont(new Font("Dialog", 1, 12));
        this.aSliderValueLabel.setBounds(175, 30, 175, 25);
        this.bSlider.setMinimumLabelString("x");
        this.bSlider.setMaximumLabelString("50");
        this.bSlider.setUnitIncrement(1);
        this.bSlider.setValue(20);
        this.bSlider.setMaximum(101);
        this.bSlider.setNumTicks(20);
        this.bSlider.setBlockIncrement(1);
        this.surfacePanel.add((Component)this.bSlider);
        this.bSlider.setForeground(Color.yellow);
        this.bSlider.setFont(new Font("Dialog", 1, 12));
        this.bSlider.setBounds(10, 269, 350, 55);
        this.bSliderValueLabel.setLabel((Object)"b = 5");
        this.bSliderValueLabel.setAlignment(3);
        this.bSliderValueLabel.setInsets(new Insets(0, 0, 0, 0));
        this.bSlider.add((Component)this.bSliderValueLabel);
        this.bSliderValueLabel.setFont(new Font("Dialog", 1, 12));
        this.bSliderValueLabel.setBounds(175, 30, 175, 25);
        this.showGradGCheckbox.setState(1);
        this.showGradGCheckbox.setLabel((Object)"Show grad g");
        this.showGradGCheckbox.setHighlightColor(new Color(0, 51, 102));
        this.surfacePanel.add((Component)this.showGradGCheckbox);
        this.showGradGCheckbox.setForeground(Color.yellow);
        this.showGradGCheckbox.setFont(new Font("Dialog", 1, 12));
        this.showGradGCheckbox.setBounds(127, 330, 112, 25);
        this.showGradFCheckbox.setState(1);
        this.showGradFCheckbox.setLabel((Object)"Show grad f");
        this.showGradFCheckbox.setHighlightColor(new Color(0, 51, 102));
        this.surfacePanel.add((Component)this.showGradFCheckbox);
        this.showGradFCheckbox.setForeground(Color.cyan);
        this.showGradFCheckbox.setFont(new Font("Dialog", 1, 12));
        this.showGradFCheckbox.setBounds(15, 330, 112, 25);
        this.plotButton.setLabel((Object)"Plot curves");
        this.surfacePanel.add((Component)this.plotButton);
        this.plotButton.setForeground(Color.white);
        this.plotButton.setFont(new Font("Dialog", 1, 12));
        this.plotButton.setBounds(130, 370, 100, 30);
        this.showSolutionsCheckbox.setLabel((Object)"Show solutions");
        this.showSolutionsCheckbox.setHighlightColor(new Color(0, 51, 102));
        this.surfacePanel.add((Component)this.showSolutionsCheckbox);
        this.showSolutionsCheckbox.setForeground(Color.red);
        this.showSolutionsCheckbox.setFont(new Font("Dialog", 1, 12));
        this.showSolutionsCheckbox.setBounds(239, 330, 131, 25);
        this.label1.setLabel((Object)"Lagrange Multipliers with Two Variables");
        this.surfacePanel.add((Component)this.label1);
        this.label1.setForeground(Color.white);
        this.label1.setFont(new Font("Dialog", 1, 12));
        this.label1.setBounds(0, 5, 370, 25);
        this.xMaxLabel.setLabel((Object)"xMax = ");
        this.xMaxLabel.setAlignment(3);
        this.xMaxLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.surfacePanel.add((Component)this.xMaxLabel);
        this.xMaxLabel.setForeground(Color.white);
        this.xMaxLabel.setFont(new Font("Dialog", 1, 12));
        this.xMaxLabel.setBounds(183, 124, 64, 30);
        this.xMaxTextField.setSelectedBackground(Color.white);
        this.xMaxTextField.setSelectionStart(1);
        this.xMaxTextField.setText("5");
        this.xMaxTextField.setInsets(new Insets(3, 3, 3, 3));
        this.xMaxTextField.setCursorPosition(1);
        this.xMaxTextField.setSelectionEnd(1);
        this.xMaxTextField.setSelectedForeground(Color.lightGray);
        this.surfacePanel.add((Component)this.xMaxTextField);
        this.xMaxTextField.setForeground(Color.white);
        this.xMaxTextField.setFont(new Font("Dialog", 1, 12));
        this.xMaxTextField.setBounds(247, 123, 40, 30);
        this.yMinTextField.setSelectedBackground(Color.white);
        this.yMinTextField.setSelectionStart(1);
        this.yMinTextField.setText("-5");
        this.yMinTextField.setInsets(new Insets(3, 3, 3, 3));
        this.yMinTextField.setCursorPosition(1);
        this.yMinTextField.setSelectionEnd(1);
        this.yMinTextField.setSelectedForeground(Color.lightGray);
        this.surfacePanel.add((Component)this.yMinTextField);
        this.yMinTextField.setForeground(Color.white);
        this.yMinTextField.setFont(new Font("Dialog", 1, 12));
        this.yMinTextField.setBounds(83, 159, 40, 30);
        this.yMaxLabel.setLabel((Object)"yMax =");
        this.yMaxLabel.setAlignment(3);
        this.yMaxLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.surfacePanel.add((Component)this.yMaxLabel);
        this.yMaxLabel.setForeground(Color.white);
        this.yMaxLabel.setFont(new Font("Dialog", 1, 12));
        this.yMaxLabel.setBounds(183, 160, 55, 30);
        this.yMaxTextField.setSelectedBackground(Color.white);
        this.yMaxTextField.setSelectionStart(1);
        this.yMaxTextField.setText("5");
        this.yMaxTextField.setInsets(new Insets(3, 3, 3, 3));
        this.yMaxTextField.setCursorPosition(1);
        this.yMaxTextField.setSelectionEnd(1);
        this.yMaxTextField.setSelectedForeground(Color.lightGray);
        this.surfacePanel.add((Component)this.yMaxTextField);
        this.yMaxTextField.setForeground(Color.white);
        this.yMaxTextField.setFont(new Font("Dialog", 1, 12));
        this.yMaxTextField.setBounds(247, 159, 40, 30);
        this.xMinLabel.setLabel((Object)"xMin =");
        this.xMinLabel.setAlignment(3);
        this.xMinLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.surfacePanel.add((Component)this.xMinLabel);
        this.xMinLabel.setForeground(Color.white);
        this.xMinLabel.setFont(new Font("Dialog", 1, 12));
        this.xMinLabel.setBounds(19, 124, 64, 30);
        this.yMinLabel.setLabel((Object)"yMin =");
        this.yMinLabel.setAlignment(3);
        this.yMinLabel.setInsets(new Insets(-2, 0, 0, 0));
        this.surfacePanel.add((Component)this.yMinLabel);
        this.yMinLabel.setForeground(Color.white);
        this.yMinLabel.setFont(new Font("Dialog", 1, 12));
        this.yMinLabel.setBounds(19, 160, 64, 30);
        this.xMinTextField.setSelectedBackground(Color.white);
        this.xMinTextField.setSelectionStart(1);
        this.xMinTextField.setText("-5");
        this.xMinTextField.setInsets(new Insets(3, 3, 3, 3));
        this.xMinTextField.setCursorPosition(1);
        this.xMinTextField.setSelectionEnd(1);
        this.xMinTextField.setSelectedForeground(Color.lightGray);
        this.surfacePanel.add((Component)this.xMinTextField);
        this.xMinTextField.setForeground(Color.white);
        this.xMinTextField.setFont(new Font("Dialog", 1, 12));
        this.xMinTextField.setBounds(83, 123, 40, 30);
        this.JCSeparator1.setShadowThickness(1);
        this.JCSeparator1.setOrientation(1);
        this.add((Component)this.JCSeparator1);
        this.JCSeparator1.setBounds(375, 30, 10, 420);
        this.graph = new Graph();
        this.add((Component)((Object)this.graph));
        this.graph.setBounds(385, 30, 370, 370);
        this.slidersPointInit();
        this.plotButton_actionPerformed();
        if (!bl) {
            this.layoutMenu();
        }
        this.keysFrame = new MkKeysFrame("");
        this.cbManager = new MkComboBoxManager((Applet)this);
        SymJCAdjustment symJCAdjustment = new SymJCAdjustment();
        this.aSlider.addAdjustmentListener((JCAdjustmentListener)symJCAdjustment);
        this.bSlider.addAdjustmentListener((JCAdjustmentListener)symJCAdjustment);
        SymJCAction symJCAction = new SymJCAction();
        this.plotButton.addActionListener((JCActionListener)symJCAction);
        SymJCItem symJCItem = new SymJCItem();
        this.showGradFCheckbox.addItemListener((JCItemListener)symJCItem);
        this.showGradGCheckbox.addItemListener((JCItemListener)symJCItem);
        this.showSolutionsCheckbox.addItemListener((JCItemListener)symJCItem);
        this.keysMenu.addActionListener((JCActionListener)symJCAction);
    }

    public void layoutMenu() {
        this.add((Component)this.menuBar);
        this.menuBar.setBounds(0, 0, 760, 30);
        this.keysMenu.setLabel("Keys");
        this.keysMenu.setItems(JCUtilConverter.toStringList((String)new String("Goal\nWhat you can do\nChallenges"), (char)'\n', (boolean)true));
        this.menuBar.addSeparator(new JCSeparator());
    }

    void slidersPointInit() {
        this.aSlider.setValue(75, true);
        this.graph.aIndex = 75;
        this.bSlider.setValue(20, true);
        this.graph.bIndex = 20;
    }

    void plotButton_actionPerformed() {
        try {
            this.graph.setVisibility(this.showGradFCheckbox.getState(), this.showGradGCheckbox.getState(), this.showSolutionsCheckbox.getState());
            this.graph.setScene(this.fxyComboBox.getText(), this.gxyComboBox.getText(), this.xMinTextField.getText(), this.xMaxTextField.getText(), this.yMinTextField.getText(), this.yMaxTextField.getText());
            this.graph.fContourValue = this.graph.aValues[this.graph.aIndex];
            this.aSliderValueLabel.setText("a = " + this.graph.sf.formatReg(this.graph.aValues[this.graph.aIndex]));
            this.aSlider.setMinimumLabelString(this.graph.sf.formatReg(this.graph.aValues[0]));
            this.aSlider.setMaximumLabelString(this.graph.sf.formatReg(this.graph.aValues[100]));
            this.graph.gContourValue = this.graph.bValues[this.graph.bIndex];
            this.bSliderValueLabel.setText("b = " + this.graph.sf.formatReg(this.graph.bValues[this.graph.bIndex]));
            this.bSlider.setMinimumLabelString(this.graph.sf.formatReg(this.graph.bValues[0]));
            this.bSlider.setMaximumLabelString(this.graph.sf.formatReg(this.graph.bValues[100]));
            this.graph.calculateContours();
            this.graph.setXLabel("x");
            this.graph.setYLabel("y");
            this.graph.render();
            return;
        }
        catch (IllegalExpressionException illegalExpressionException) {
            this.graph.drawEmptyPlot();
            new MkErrorFrame(illegalExpressionException.getMessage());
            return;
        }
    }

    void keysMenu_actionPerformed(JCActionEvent jCActionEvent) {
        String string = jCActionEvent.getActionCommand();
        if (string.equals("Goal")) {
            this.keysFrame.openFile((Applet)this, "keys/lagrange_multipliers_two_variables/goal.txt");
            this.keysFrame.setTitle("Keys - Goal");
            this.keysFrame.setVisible(true);
            return;
        }
        if (string.equals("What you can do")) {
            this.keysFrame.openFile((Applet)this, "keys/lagrange_multipliers_two_variables/what.txt");
            this.keysFrame.setTitle("Keys - What you can do");
            this.keysFrame.setVisible(true);
            return;
        }
        if (string.equals("Challenges")) {
            this.keysFrame.openFile((Applet)this, "keys/lagrange_multipliers_two_variables/challenges.txt");
            this.keysFrame.setTitle("Keys - Challenges");
            this.keysFrame.setVisible(true);
        }
    }

    void aSlider_adjustmentValueChanged(JCAdjustmentEvent jCAdjustmentEvent) {
        try {
            this.graph.slideA(jCAdjustmentEvent.getValue());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void bSlider_adjustmentValueChanged(JCAdjustmentEvent jCAdjustmentEvent) {
        try {
            this.graph.slideB(jCAdjustmentEvent.getValue());
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void showGradFCheckbox_itemStateChanged() {
        try {
            this.graph.setVisibility(this.showGradFCheckbox.getState(), this.showGradGCheckbox.getState(), this.showSolutionsCheckbox.getState());
            this.graph.render();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void showGradGCheckbox_itemStateChanged() {
        try {
            this.graph.setVisibility(this.showGradFCheckbox.getState(), this.showGradGCheckbox.getState(), this.showSolutionsCheckbox.getState());
            this.graph.render();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void showSolutionsCheckbox_itemStateChanged() {
        try {
            this.graph.setVisibility(this.showGradFCheckbox.getState(), this.showGradGCheckbox.getState(), this.showSolutionsCheckbox.getState());
            this.graph.render();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    class Graph
    extends MkRenderer2D {
        double[] xArr;
        double[] yArr;
        double[][] fArr;
        double[][] gArr;
        double[] xSolArr;
        double[] ySolArr;
        double[][] solArr;
        double[] aValues;
        double[] bValues;
        MkContourPath[] fpaths;
        MkContourPath[] allfpaths;
        MkContourPath[] gpaths;
        MkContourPath[] solpaths;
        double fContourValue;
        double gContourValue;
        MkGeomCurve2D[] fcontours;
        MkGeomCurve2D[] allfcontours;
        MkGeomCurve2D[] gcontours;
        MkGeomCurve2D[] solcontours;
        int nfpaths;
        int allnfpaths;
        int ngpaths;
        int nsolpaths;
        int aIndex;
        int bIndex;
        int showGradF = 1;
        int showGradG = 1;
        int showSolutions = 1;
        boolean showGridLines = true;
        boolean gradientPointSelected;
        MkGeomPoint2D gradientPoint = new MkGeomPoint2D();
        MkGeomVector2D gradientVectorFxy = new MkGeomVector2D();
        MkGeomVector2D gradientVectorGxy = new MkGeomVector2D();
        double xMinStored = -5.0;
        double xMaxStored = 5.0;
        double yMinStored = -5.0;
        double yMaxStored = 5.0;

        public Graph() {
            LagrangeMultipliersTwoVariables.this = LagrangeMultipliersTwoVariables.this;
            this.gradientPoint.setColor(Color.magenta);
            this.selectableShapes.addElement(this.gradientPoint);
            this.gradientPoint.setPoint(1.0, 1.0);
            this.gradientVectorFxy.setColor(Color.cyan);
            this.gradientVectorGxy.setColor(Color.yellow);
            this.hasSelectableShapes = true;
        }

        public void selectShape(int n, int n2) {
            double d = n - this.ulx();
            double d2 = this.lry() - n2;
            d /= this.xScale();
            d2 /= this.yScale();
            this.gradientPointSelected = true;
            this.gradientPoint.setPoint(d += this.xMin(), d2 += this.yMin());
            this.render();
        }

        public void moveSelectedShape(double d, double d2) {
            if (this.gradientPointSelected) {
                this.gradientPoint.setPoint(d, d2);
                this.render();
            }
        }

        public void deSelectShape(double d, double d2) {
            if (this.gradientPointSelected) {
                this.gradientPointSelected = false;
                this.gradientPoint.setPoint(d, d2);
                this.render();
            }
        }

        public void setVisibility(int n, int n2, int n3) {
            this.showGradF = n;
            this.showGradG = n2;
            this.showSolutions = n3;
        }

        public void setScene(String string, String string2, String string3, String string4, String string5, String string6) throws IllegalExpressionException {
            this.parser1.parseExpression(string3);
            double d = this.parser1.getValue();
            MkMath.checkValidityOfDouble((double)d, (String)string3);
            this.parser1.parseExpression(string4);
            double d2 = this.parser1.getValue();
            MkMath.checkValidityOfDouble((double)d2, (String)string4);
            this.parser1.parseExpression(string5);
            double d3 = this.parser1.getValue();
            MkMath.checkValidityOfDouble((double)d3, (String)string5);
            this.parser1.parseExpression(string6);
            double d4 = this.parser1.getValue();
            MkMath.checkValidityOfDouble((double)d4, (String)string6);
            int n = 50;
            int n2 = 100;
            this.clear();
            double d5 = (d2 - d) / 10.0;
            double d6 = (d4 - d3) / 10.0;
            if (this.xMinStored != d || this.xMaxStored != d2 || this.yMinStored != d3 || this.yMaxStored != d4) {
                this.gradientPoint.setPoint((d2 + d) / 2.0 + d5, (d4 + d3) / 2.0 + d6);
                this.xMinStored = d;
                this.xMaxStored = d2;
                this.yMinStored = d3;
                this.yMaxStored = d4;
            }
            this.xArr = new double[n + 1];
            this.yArr = new double[n + 1];
            this.fArr = new double[n + 1][n + 1];
            this.gArr = new double[n + 1][n + 1];
            this.xSolArr = new double[n2 + 1];
            this.ySolArr = new double[n2 + 1];
            this.solArr = new double[n2 + 1][n2 + 1];
            double d7 = (d2 - d) / (double)n;
            double d8 = (d4 - d3) / (double)n;
            double d9 = (d2 - d) / (double)n2;
            double d10 = (d4 - d3) / (double)n2;
            int n3 = 0;
            double d11 = d;
            while (n3 <= n) {
                this.xArr[n3] = d11;
                ++n3;
                d11 += d7;
            }
            int n4 = 0;
            double d12 = d3;
            while (n4 <= n) {
                this.yArr[n4] = d12;
                ++n4;
                d12 += d8;
            }
            n3 = 0;
            d11 = d;
            while (n3 <= n2) {
                this.xSolArr[n3] = d11;
                ++n3;
                d11 += d9;
            }
            n4 = 0;
            d12 = d3;
            while (n4 <= n2) {
                this.ySolArr[n4] = d12;
                ++n4;
                d12 += d10;
            }
            this.parser1.addVariable("x", 0.0);
            this.parser1.addVariable("y", 0.0);
            this.parser1.parseExpression(string);
            this.parser2.addVariable("x", 0.0);
            this.parser2.addVariable("y", 0.0);
            this.parser2.parseExpression(string2);
            double d13 = Double.MAX_VALUE;
            double d14 = -1.7976931348623157E308;
            double d15 = Double.MAX_VALUE;
            double d16 = -1.7976931348623157E308;
            n3 = 0;
            d11 = d;
            while (n3 <= n) {
                this.parser1.addVariable("x", d11);
                this.parser2.addVariable("x", d11);
                n4 = 0;
                d12 = d3;
                while (n4 <= n) {
                    this.parser1.addVariable("y", d12);
                    this.fArr[n4][n3] = this.parser1.getValue();
                    d13 = Math.min(d13, this.fArr[n4][n3]);
                    d14 = Math.max(d14, this.fArr[n4][n3]);
                    this.parser2.addVariable("y", d12);
                    this.gArr[n4][n3] = this.parser2.getValue();
                    d15 = Math.min(d15, this.gArr[n4][n3]);
                    d16 = Math.max(d16, this.gArr[n4][n3]);
                    ++n4;
                    d12 += d8;
                }
                ++n3;
                d11 += d7;
            }
            n3 = 0;
            d11 = d;
            while (n3 <= n2) {
                n4 = 0;
                d12 = d3;
                while (n4 <= n2) {
                    double d17 = this.getFPartialX(d11, d12);
                    double d18 = this.getFPartialY(d11, d12);
                    double d19 = this.getGPartialX(d11, d12);
                    double d20 = this.getGPartialY(d11, d12);
                    this.solArr[n4][n3] = d17 * d20 - d18 * d19;
                    ++n4;
                    d12 += d10;
                }
                ++n3;
                d11 += d9;
            }
            this.setXRange(d, d2);
            this.setYRange(d3, d4);
            double d21 = d13;
            double d22 = d14;
            double d23 = d15;
            double d24 = d16;
            int n5 = 100;
            int n6 = 100;
            double d25 = (d22 - d21) / (double)n5;
            double d26 = (d24 - d23) / (double)n6;
            this.aValues = new double[n5 + 1];
            this.bValues = new double[n6 + 1];
            n3 = 0;
            double d27 = d21;
            while (n3 <= n5) {
                this.aValues[n3] = d27;
                ++n3;
                d27 += d25;
            }
            n3 = 0;
            double d28 = d23;
            while (n3 <= n6) {
                this.bValues[n3] = d28;
                ++n3;
                d28 += d26;
            }
        }

        public void calculateContours() {
            try {
                MkContourAttrib[] mkContourAttribArray = new MkContourAttrib[]{new MkContourAttrib(this.fContourValue)};
                MkContourAttrib[] mkContourAttribArray2 = new MkContourAttrib[26];
                int n = 0;
                while (n < 26) {
                    mkContourAttribArray2[n] = new MkContourAttrib(this.aValues[4 * n]);
                    ++n;
                }
                MkContourAttrib[] mkContourAttribArray3 = new MkContourAttrib[]{new MkContourAttrib(this.gContourValue)};
                MkContourAttrib[] mkContourAttribArray4 = new MkContourAttrib[]{new MkContourAttrib(0.0)};
                MkContourGenerator mkContourGenerator = new MkContourGenerator(this.xArr, this.yArr, this.fArr, mkContourAttribArray);
                this.fpaths = mkContourGenerator.getContours();
                this.nfpaths = this.fpaths.length;
                MkContourGenerator mkContourGenerator2 = new MkContourGenerator(this.xArr, this.yArr, this.fArr, mkContourAttribArray2);
                this.allfpaths = mkContourGenerator2.getContours();
                this.allnfpaths = this.allfpaths.length;
                MkContourGenerator mkContourGenerator3 = new MkContourGenerator(this.xArr, this.yArr, this.gArr, mkContourAttribArray3);
                this.gpaths = mkContourGenerator3.getContours();
                this.ngpaths = this.gpaths.length;
                MkContourGenerator mkContourGenerator4 = new MkContourGenerator(this.xSolArr, this.ySolArr, this.solArr, mkContourAttribArray4);
                this.solpaths = mkContourGenerator4.getContours();
                this.nsolpaths = this.solpaths.length;
                this.fcontours = new MkGeomCurve2D[this.nfpaths];
                this.allfcontours = new MkGeomCurve2D[this.allnfpaths];
                this.gcontours = new MkGeomCurve2D[this.ngpaths];
                this.solcontours = new MkGeomCurve2D[this.nsolpaths];
                int n2 = 0;
                while (n2 < this.nfpaths) {
                    this.fcontours[n2] = null;
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.nfpaths) {
                    this.allfcontours[n2] = null;
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.ngpaths) {
                    this.gcontours[n2] = null;
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.nsolpaths) {
                    this.solcontours[n2] = null;
                    ++n2;
                }
                double[] dArray = null;
                double[] dArray2 = null;
                n2 = 0;
                while (n2 < this.nfpaths) {
                    dArray = this.fpaths[n2].getAllX();
                    dArray2 = this.fpaths[n2].getAllY();
                    this.fcontours[n2] = new MkGeomCurve2D();
                    this.fcontours[n2].setCurve(dArray, dArray2);
                    ++n2;
                }
                double[] dArray3 = null;
                double[] dArray4 = null;
                n2 = 0;
                while (n2 < this.allnfpaths) {
                    dArray3 = this.allfpaths[n2].getAllX();
                    dArray4 = this.allfpaths[n2].getAllY();
                    this.allfcontours[n2] = new MkGeomCurve2D();
                    this.allfcontours[n2].setCurve(dArray3, dArray4);
                    ++n2;
                }
                double[] dArray5 = null;
                double[] dArray6 = null;
                n2 = 0;
                while (n2 < this.ngpaths) {
                    dArray5 = this.gpaths[n2].getAllX();
                    dArray6 = this.gpaths[n2].getAllY();
                    this.gcontours[n2] = new MkGeomCurve2D();
                    this.gcontours[n2].setCurve(dArray5, dArray6);
                    ++n2;
                }
                double[] dArray7 = null;
                double[] dArray8 = null;
                n2 = 0;
                while (n2 < this.nsolpaths) {
                    dArray7 = this.solpaths[n2].getAllX();
                    dArray8 = this.solpaths[n2].getAllY();
                    this.solcontours[n2] = new MkGeomCurve2D();
                    this.solcontours[n2].setCurve(dArray7, dArray8);
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.nfpaths) {
                    this.fcontours[n2].setColor(Color.green);
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.allnfpaths) {
                    this.allfcontours[n2].setColor(Color.cyan);
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.ngpaths) {
                    this.gcontours[n2].setColor(Color.yellow);
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.nsolpaths) {
                    this.solcontours[n2].setColor(Color.red);
                    ++n2;
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void render() {
            double d;
            double d2;
            this.drawAxes();
            if (this.showGridLines) {
                this.drawHGrid();
                this.drawVGrid();
            }
            int n = 0;
            while (n < this.nfpaths) {
                this.fcontours[n].render((MkRenderer2D)this);
                ++n;
            }
            n = 0;
            while (n < this.allnfpaths) {
                this.allfcontours[n].render((MkRenderer2D)this);
                ++n;
            }
            n = 0;
            while (n < this.ngpaths) {
                this.gcontours[n].render((MkRenderer2D)this);
                ++n;
            }
            if (this.showSolutions == 1) {
                n = 0;
                while (n < this.nsolpaths) {
                    this.solcontours[n].render((MkRenderer2D)this);
                    ++n;
                }
            }
            if (this.showGradF == 1) {
                d2 = this.gradientPoint.x;
                d = this.gradientPoint.y;
                this.gradientVectorFxy.setAnchor(d2, d);
                this.gradientVectorFxy.setVector(this.getFPartialX(d2, d), this.getFPartialY(d2, d));
                LagrangeMultipliersTwoVariables.this.fValueLabel.setText("f = " + this.sf.formatReg(this.getF(d2, d)) + ";");
                LagrangeMultipliersTwoVariables.this.gradfValueLabel.setText("grad f = <" + this.sf.formatReg(this.gradientVectorFxy.x) + ", " + this.sf.formatReg(this.gradientVectorFxy.y) + ">");
                this.gradientVectorFxy.render((MkRenderer2D)this);
            } else {
                LagrangeMultipliersTwoVariables.this.fValueLabel.setText("f = -----;");
                LagrangeMultipliersTwoVariables.this.gradfValueLabel.setText("grad f = <-----, ----->");
            }
            if (this.showGradG == 1) {
                d2 = this.gradientPoint.x;
                d = this.gradientPoint.y;
                this.gradientVectorGxy.setAnchor(d2, d);
                this.gradientVectorGxy.setVector(this.getGPartialX(d2, d), this.getGPartialY(d2, d));
                LagrangeMultipliersTwoVariables.this.gValueLabel.setText("g = " + this.sf.formatReg(this.getG(d2, d)) + ";");
                LagrangeMultipliersTwoVariables.this.gradgValueLabel.setText("grad g = <" + this.sf.formatReg(this.gradientVectorGxy.x) + ", " + this.sf.formatReg(this.gradientVectorGxy.y) + ">");
                this.gradientVectorGxy.render((MkRenderer2D)this);
            } else {
                LagrangeMultipliersTwoVariables.this.gValueLabel.setText("g = -----;");
                LagrangeMultipliersTwoVariables.this.gradgValueLabel.setText("grad g = <-----, ----->");
            }
            if (this.showGradF == 1 || this.showGradG == 1) {
                LagrangeMultipliersTwoVariables.this.posValueLabel.setText("At (x, y) = (" + this.sf.formatReg(this.gradientPoint.x) + ", " + this.sf.formatReg(this.gradientPoint.y) + "):");
                this.gradientPoint.render((MkRenderer2D)this);
            } else {
                LagrangeMultipliersTwoVariables.this.posValueLabel.setText("At (x, y) = (-----, -----)");
            }
            this.swap();
        }

        public void slideA(int n) {
            if (!this.graphIsEmpty) {
                this.setVisibility(LagrangeMultipliersTwoVariables.this.showGradFCheckbox.getState(), LagrangeMultipliersTwoVariables.this.showGradGCheckbox.getState(), LagrangeMultipliersTwoVariables.this.showSolutionsCheckbox.getState());
                this.aIndex = n;
                LagrangeMultipliersTwoVariables.this.aSliderValueLabel.setText("a = " + this.sf.formatReg(this.aValues[this.aIndex]));
                this.fContourValue = this.aValues[this.aIndex];
                this.calculateContours();
                this.render();
                return;
            }
            this.drawEmptyPlot();
        }

        public void slideB(int n) {
            if (!this.graphIsEmpty) {
                this.setVisibility(LagrangeMultipliersTwoVariables.this.showGradFCheckbox.getState(), LagrangeMultipliersTwoVariables.this.showGradGCheckbox.getState(), LagrangeMultipliersTwoVariables.this.showSolutionsCheckbox.getState());
                this.bIndex = n;
                LagrangeMultipliersTwoVariables.this.bSliderValueLabel.setText("b = " + this.sf.formatReg(this.bValues[this.bIndex]));
                this.gContourValue = this.bValues[this.bIndex];
                this.calculateContours();
                this.render();
                return;
            }
            this.drawEmptyPlot();
        }

        public double getF(double d, double d2) {
            this.parser1.addVariable("x", d);
            this.parser1.addVariable("y", d2);
            return this.parser1.getValue();
        }

        public double getG(double d, double d2) {
            this.parser2.addVariable("x", d);
            this.parser2.addVariable("y", d2);
            return this.parser2.getValue();
        }

        public double getFPartialX(double d, double d2) {
            this.parser1.addVariable("y", d2);
            this.parser1.addVariable("x", d - 1.0E-5);
            double d3 = this.parser1.getValue();
            this.parser1.addVariable("x", d + 1.0E-5);
            double d4 = this.parser1.getValue();
            return (d4 - d3) / 2.0E-5;
        }

        public double getFPartialY(double d, double d2) {
            this.parser1.addVariable("x", d);
            this.parser1.addVariable("y", d2 - 1.0E-5);
            double d3 = this.parser1.getValue();
            this.parser1.addVariable("y", d2 + 1.0E-5);
            double d4 = this.parser1.getValue();
            return (d4 - d3) / 2.0E-5;
        }

        public double getGPartialX(double d, double d2) {
            this.parser2.addVariable("y", d2);
            this.parser2.addVariable("x", d - 1.0E-5);
            double d3 = this.parser2.getValue();
            this.parser2.addVariable("x", d + 1.0E-5);
            double d4 = this.parser2.getValue();
            return (d4 - d3) / 2.0E-5;
        }

        public double getGPartialY(double d, double d2) {
            this.parser2.addVariable("x", d);
            this.parser2.addVariable("y", d2 - 1.0E-5);
            double d3 = this.parser2.getValue();
            this.parser2.addVariable("y", d2 + 1.0E-5);
            double d4 = this.parser2.getValue();
            return (d4 - d3) / 2.0E-5;
        }
    }

    class SymJCAction
    implements JCActionListener {
        public void actionPerformed(JCActionEvent jCActionEvent) {
            Object object = jCActionEvent.getSource();
            if (object == LagrangeMultipliersTwoVariables.this.plotButton) {
                LagrangeMultipliersTwoVariables.this.plotButton_actionPerformed();
                return;
            }
            if (object == LagrangeMultipliersTwoVariables.this.keysMenu) {
                LagrangeMultipliersTwoVariables.this.keysMenu_actionPerformed(jCActionEvent);
            }
        }

        SymJCAction() {
            LagrangeMultipliersTwoVariables.this = LagrangeMultipliersTwoVariables.this;
        }
    }

    class SymJCAdjustment
    implements JCAdjustmentListener {
        public void adjustmentValueChanged(JCAdjustmentEvent jCAdjustmentEvent) {
            Object object = jCAdjustmentEvent.getSource();
            if (object == LagrangeMultipliersTwoVariables.this.aSlider) {
                LagrangeMultipliersTwoVariables.this.aSlider_adjustmentValueChanged(jCAdjustmentEvent);
                return;
            }
            if (object == LagrangeMultipliersTwoVariables.this.bSlider) {
                LagrangeMultipliersTwoVariables.this.bSlider_adjustmentValueChanged(jCAdjustmentEvent);
            }
        }

        SymJCAdjustment() {
            LagrangeMultipliersTwoVariables.this = LagrangeMultipliersTwoVariables.this;
        }
    }

    class SymJCItem
    implements JCItemListener {
        public void itemStateChanged(JCItemEvent jCItemEvent) {
            Object object = jCItemEvent.getSource();
            if (object == LagrangeMultipliersTwoVariables.this.showGradFCheckbox) {
                LagrangeMultipliersTwoVariables.this.showGradFCheckbox_itemStateChanged();
                return;
            }
            if (object == LagrangeMultipliersTwoVariables.this.showGradGCheckbox) {
                LagrangeMultipliersTwoVariables.this.showGradGCheckbox_itemStateChanged();
                return;
            }
            if (object == LagrangeMultipliersTwoVariables.this.showSolutionsCheckbox) {
                LagrangeMultipliersTwoVariables.this.showSolutionsCheckbox_itemStateChanged();
            }
        }

        SymJCItem() {
            LagrangeMultipliersTwoVariables.this = LagrangeMultipliersTwoVariables.this;
        }
    }
}

