function [t,y]=plot_data(nval,pval)
% function [t,y]=plot_data(nval,pval)
%
% ------------USAGE---------------------------------------------------
% MAKE SURE YOU HAVE SAVED DATA IN "SPREADSHEET" FORMAT!!! (.CSV file)
% --Inputs:
% nval is the number for the scope file. If your file
%    is saved as "TEK00014.CSV", then nval=14.
%    (nval=00014 is also fine!)
%    (nval='TEK00014.CSV' is ok, too, but be sure you are exact!)
% pval is an optional PLOTTING symbol, such as 'b.-'
% 
% --Outputs:
% t is a 1xn vector of TIME values for the scope data
% y is a 1xn vector of VOLTAGE values for the scope data
% --------------------------------------------------------------------
% 
% --> TO RUN THIS FUNCTION to load and plot data from a scope data <-----
%     file called 'TEK00017.CSV', you would type the following:
% 
% [t,y] = plot_scope(17)

%---------CREATE SCOPE DATA FILE NAME------------------------
if ischar(nval)
    sval=nval;
else
    sval='TEK';      % sval will be scope data file name
    n=num2str(nval);
    while length(n)<5
        n=['0' n];   % create 5-digit number
    end
    sval=[sval n '.CSV'];
end
%----------LOAD the file (a=load('TEK00014.DAT'))------------
q=fopen(sval,'r');  % first looks in local dir...
if q==-1
    sval=['a:' sval]; % ...then sets to a: if unsuccessful.
else
    fclose(q);
end
a=load(sval);
t=a(:,1);
y=a(:,2);
%----------PLOT the DATA-------------------------------------
if ~exist('pval')
    pval='b.-';
end
plot(t,y,pval)
grid on
xlabel('Time [s]');
ylabel('Position');

