function [s1,s2,k,b] = dolab3(T, tau, m)
% function [s1,s2,k,b] = dolab3(T, tau, m)
%
% This function has 3 inputs:
%   T (the period between two successive peaks)
%   tau (the time constant of the decay envelope)
%   m (the mass of the system = .85 kg)
%
% If you put some commented lines directly below they function declaraction,
% they become the "help" text (if you type "help dolab3" in MATLAB). 

% Since this function is called "dolab3", it should be saved as "dolab3.m".

wd = 2*pi./T;
sigma = 1./tau;
s1 = -sigma + wd*j;
s2 = -sigma - wd*j;
wn = sqrt(sigma.^2 + wd.^2);
zeta = sigma./wn;
k = m .* wn.^2;  
b = 2*m.*zeta.*wn;

figure(1); clf; subplot(121);
for m=1:2
    plot(real(s1),imag(s1),'kx'); hold on
    plot(real(s2),imag(s2),'kx');
    for n=1:length(s1)
        text(real(s1(n)),imag(s1(n)), [' ' num2str(n)]);
        text(real(s2(n)),imag(s2(n)),[' ' num2str(n)]);
    end
    grid on; axis([1.1*min(real(s1)) 0 -1.1*max(imag(s1)) 1.1*max(imag(s1))]);
    subplot(122);
end
axis image; axis([-1.1*max(imag(s1)) .2*max(imag(s1)) -1.1*max(imag(s1)) 1.1*max(imag(s1))]);
