clear all;
clc;

d = .001016;
r = d/2;
l=0.04:0.001:0.170;
E=210E9;
I=1/4*pi*r^4
k=12*E*I./(l.^3);
12*E*I
figure(1),plot(l,k);

title('Stiffness vs. Length');
xlabel('Length [m]');
ylabel('stiffness [N/m]');
axis tight
grid on


wd = 4/2.4 * 2*pi
zetawn = -log(1.25/3)/0.65
wn=sqrt(wd^2+zetawn^2)
k = wn^2*0.85
zeta = zetawn/wn
c = zeta*2*sqrt(k*.085)

wn=14
zn=11.9
their_k = wn^2 * .85
their_zeta = zn/wn
their_c = 2*sqrt(their_k*.85)*their_zeta


%prob 3
%for small length 
l=.050;
k1=12*E*I/l^3
c = 6
m=0.85
s = roots([m,c,k1])

sys1 = zpk([],s,1)


l=.160;
k1=12*E*I/l^3
c = 6
m=0.85
s = roots([m,c,k1])

sys2 = zpk([],s,1)

l=.050;
k1=12*E*I/l^3
c = 14
m=0.85
s = roots([m,c,k1])

sys3 = zpk([],s,1)


l=.160;
k1=12*E*I/l^3
c = 14
m=0.85
s = roots([m,c,k1])

sys4 = zpk([],s,1)
figure(2),pzmap(sys1,sys2,sys3,sys4)



sys1=tf(1,[.85,6,600]);
sys2 = tf(1,[.85,14,600]);
figure(3),step(sys1,sys2)