function specdata(nval,flag)
% function [t,y,tsim,ysim] = specdata(nval,flag)
%
% This function is similar to plot_data(), except that the user is
% prompted to click on the starting position and final height (F.V.)
% in the raw data, and the data is then replotted with bars to
% indicate 10%, 90%, 95% and 105%
%
% ------------USAGE---------------------------------------------------
% MAKE SURE YOU HAVE SAVED DATA IN "SPREADSHEET" FORMAT!!! (.CSV file)
% --Inputs:
% nval is the number for the scope file. If your file
%    is saved as "TEK00014.CSV", then nval=14.
%    (nval=00014 is also fine!)
%    (nval='TEK00014.CSV' is ok, too, but be sure you are exact!)
% flag - when flag == 'cheat', the program will automatically
%    estimate tr, ts, and (when it overshoots) Mp and tp (and
%    then show zeta, wd and wn).
% 
% --Outputs:
% t is a 1xn vector of TIME values for the scope data
% y is a 1xn vector of VOLTAGE values for the scope data
% ysim is a 1xn vector which SIMULATES a STEP RESPONSE
% --------------------------------------------------------------------
% 
% --> TO RUN THIS FUNCTION to load and plot data from a scope data <-----
%     file called 'TEK00017.CSV', you would type the following:
% 
% [t,y,ysim] = plot_scope(17)
if ~exist('flag')
    flag=0;
else
    if strcmpi(flag(1),'c')
        flag=1;
    elseif flag~=1
        flag=0;
    end
end

%---------CLF??----------------------------------------------
if ~exist('noclf'),    clf
else,    if noclf~=0,        clf,    end
end
%---------CREATE SCOPE DATA FILE NAME------------------------
if ischar(nval)
    sval=nval;
else
    sval='TEK';      % sval will be scope data file name
    n=num2str(nval);
    while length(n)<5
        n=['0' n];   % create 5-digit number
    end
    sval=[sval n '.CSV'];
end
%----------LOAD the file (a=load('TEK00014.DAT'))------------
q=fopen(sval,'r');  % first looks in local dir...
if q==-1
    sval=['a:' sval]; % ...then sets to a: if unsuccessful.
else
    fclose(q);
end
a=load(sval);
t=a(:,1);
y=a(:,2);
%---------PLOT DATA------------------------------------------
if ~exist('pval')
    pval='b-';
end
plot(t,y,'b-');
xlabel('Time [s]'); ylabel('Raw scope data before scaling'); grid on
%---------GET INITIAL AND FINAL VALUES-----------------------
fprintf('Click on the initial (x,y) value of the step OR on a PEAK.\n')
title('Click on the initial (x,y) value of the step OR on a PEAK.')
pt1=ginput(1);
fprintf('Now click to indicate the y position of the final value of the step.\n');
fprintf('(Only the y position matters for this second point...)\n')
title('Click to indicate "final value"')
pt2=ginput(1);
t=t-pt1(1);
y=y-pt1(2);
A=pt2(2)-pt1(2);
y = (1/A)*y;
cla; plot(t,y,pval); grid on
if 1==0 %------------------- kill from here......
    title('Now go back to MATLAB window to continue...')
    %---------PROMPT for 2nd-order system information------------
    fprintf('To simulate a unit step response for a 2nd-order system,\n');
    fprintf('I need two values from you.  Just enter 0 to skip the\n');
    fprintf('simulated response, otherwise:\n');
    fprintf('  0 : (No simulated response, please!)\n');
    fprintf('  1 : s1 and s2 (the pole locations, by default), or\n');
    fprintf('  2 : wd and zeta\n');
    choice = input('Enter either 1 or 2: ');
    choice = round(choice);
    if ~isempty('choice')
        choice=0;
    end
    if choice == 0
        % do no plot simulated response!
    else    
        if choice == 2
            wd = input('Enter wd:  ');
            zeta = input('Enter zeta:  ');
            wn = wd*sqrt(1+zeta^2);
            s1 = -zeta*wn + i*wd;
            s2 = -zeta*wn - i*wd;
        else
            if choice ~= 1
                fprintf('(default is POLE LOCATIONS...)')
            end
            fprintf('A pole may be either Real (-7) or Complex (-2 + 3.3*i)\n')
            s1 = input('Enter s1:  ');
            if imag(s1)~=0
                s2 = conj(s1);
                fprintf('Since s1 is complex --> s2 = %.3f\n',s2);
            else
                s2 = input('Enter second REAL pole, s2:  ');
            end
            wn = sqrt(s1*s2);
            zeta = -(s1+s2)/(2*wn);
        end
        %--------PLOT DATA AND THEORETICAL RESPONSE------------------
        cla; plot(t,y,pval); hold on; grid on
        if ~isempty(s2)
            k = (s1*s2);
            zpk1=zpk([],[s1 s2],k);
            [ysim,tsim]=step(zpk1,max(t)*[0:.001:1]);
            plot(tsim,ysim,'r--')
            if imag(s1)~=0
                zpk2=zpk([],[real(s1)],abs(real(s1)));
                [yenv,tenv]=step(zpk2,max(t)*[0:.001:1]);
                u1=plot(tenv,yenv,'g:')
                set(u1,'Color',[0 .6 0])
                u1=plot(tenv,2-yenv,'g:')
                set(u1,'Color',[0 .6 0])
                legend('normalized scope data','simulated step response','decay envelope')
            else
                legend('normalized scope data','simulated step response')
            end
            title(['Simulated Response is for s = ' [num2str(real(s1),'%.2f')] ...
                    ' \pm ' [num2str(imag(s1),'%.2f')] 'j ; \omega_n = ' ...
                    [num2str(wn,'%.2f')] ' [rad/s] ; \zeta = ' [num2str(zeta,'%.3f')]])
        else
            k=abs(s1);
            zpk1=zpk([],[s1],k);
            [ysim,tsim]=step(zpk1,max(t)*[0:.001:1]);
            plot(tsim,ysim,'r--')
            legend('normalized scope data','simulated 1st-order step response')
            title(['Simulated Response is for s = ' [num2str(real(s1),'%.2f')]])
        end
    end
end %------------------- ...until here!
tlast=max(t); nlast=length(t);
hold on;
plot([-.1*tlast 1.1*tlast],.1+[0 0],'g--');
plot([-.1*tlast 1.1*tlast],.9+[0 0],'g--');
plot([-.1*tlast 1.1*tlast],.95+[0 0],'r-.');
plot([-.1*tlast 1.1*tlast],1.05+[0 0],'r-.');
p1=floor(interp1(t,[1:length(t)],0));
if p1<2
    p1=2;
end
while ~exist('t90') & p1<length(t)
    if y(p1)>.1
        if ~exist('t10')
            t10=t(p1-1)+(t(p1)-t(p1-1))*(.1-y(p1-1))/(y(p1)-y(p1-1));
        end
        if y(p1)>.9
            if ~exist('t90')
                t90=t(p1-1)+(t(p1)-t(p1-1))*(.9-y(p1-1))/(y(p1)-y(p1-1));
                tr=t90-t10;
            end
        end
    end
    p1=p1+1;
end
p1=length(t);
if flag
    fprintf('\n-------------------------\nt(10%%)     = %6.3f (s)\n',t10);
    fprintf('t(90%%)     = %6.3f (s)\n',t90);
    fprintf('tr(10-90%%) = %6.3f (s)\n',(t90-t10));
end
Mp=0; ncross=0;
for n=2:nlast
    if (y(n-1)<.95) & (y(n)>.95)
        ncross=ncross+1;
        ts(ncross)=interp1(y((n-1):n),t((n-1):n),.95);
        tsy(ncross)=.95;
    end
    if (y(n-1)>1.05) & (y(n)<1.05)
        ncross=ncross+1;
        ts(ncross)=interp1(y((n-1):n),t((n-1):n),1.05);
        tsy(ncross)=1.05;
    end
%    if (abs(y(n)-1)<.05) & (abs(y(n-1)-1)>.05);
%        ts=t(n);
%        plot(ts,y(n),'r*');
%    end
    if (y(n)-1)>Mp
        Mp = y(n)-1;
        tp = t(n);
    end
end
if flag
    if abs(y(nlast)-1)<.05
        fprintf('ts(5%%)     = %6.3f (s)\n',ts(ncross));
    else
        ts=[];
        fprintf('Response does not appear to settle within +/- 5\% of final value...\n');
    end
    
    fprintf('tp         = %6.3f (s)\n',tp);
    fprintf('Mp =    %6.4f\n',Mp);
    
    
    if (Mp>0) & (Mp<1)
        zeta=sqrt((log(Mp)^2)/(pi^2 + (log(Mp))^2));
        wd=pi/tp;
        wn=wd*sqrt(1+zeta^2);
        fprintf('\n...If (but only if) Mp and tp are right \n(i.e. make sense on the plot), then:\n\n');
        fprintf('zeta = sqrt((log(Mp)^2))/(pi^2 + (log(Mp))^2)\n');
        fprintf('     = sqrt((%.5f)^2/(%.5f + (%.5f)^2))\n', -log(Mp), pi^2, -log(Mp));
        fprintf('zeta = %.5f\n',zeta);
        fprintf('wd = pi/tp = %.5f (rad/s)\n', wd);
        fprintf('wn = wd*sqrt(1+zeta^2) = %.5f (rad/s)\n\n',wn);
    end
    
    q=input('Do you want to plot Mp et al? \n(enter y or n [default is yes])','s');
    if isempty(q)
        q='y';
    end
    if ~strcmpi(q,'n')
        plot(tp,Mp+1,'bo'); 
        plot([t10 t90],[.1 .9],'gp');
        plot(ts,tsy,'r*'); drawnow;
        %else
        %q
    end
end

axis([-.1*tlast 1.1*tlast -.05 2.05]);
grid on; xlabel('Time(sec)'); ylabel('Normalized Output')
if flag
    sval=['tp=' num2str(tp,'%6.3f') ' (s); Mp=' num2str(Mp,'%6.3f') '; tr=' num2str(tr,'%6.3f') '(s); ts=' num2str(ts(ncross),'%6.3f') '(s)'];
    title(sval)
end
