function [T,Y]=RockerAN(theta0)
% Solver for rolling half-disk
% with analytic solution
% Input argument: Initial conditions
% Output arguement: time and angle matrix

% define some constants
g=9.81;         % gravity
r=1;            % radius of disk
rc=4*r/(3*pi);  % center of gravity

% coefficients for analytic solution
Omega=sqrt((g*rc)/(3/2*r^2-2*r*rc));    % natural frequency
A=theta0(1);
B=theta0(2)/Omega;

% define time series with time step of 0.01
T=[0:0.01:10]';
% calculate rotation angle at a given time
Y=A*cos(Omega*T)+B.*sin(Omega*T);
end