# lecture2a.py
#

import sys
sys.path.append('..')

from common.core import *
from common.audio import *
from common.writer import *
from common.mixer import *
from common.note import *
from common.gfxutil import topleft_label
from wavesrc import *


kPitches1 = (60,62,64,65,67,69,71,72,74)

# A breif review of note playing.
class MainWidget1(BaseWidget) :
    def __init__(self):
        super(MainWidget1, self).__init__()

        self.audio = Audio(2)
        self.mixer = Mixer()
        self.audio.set_generator(self.mixer)

        self.info = topleft_label()
        self.add_widget(self.info)

    def on_update(self) :
        self.audio.on_update()
        self.info.text = 'load:%.2f\n' % self.audio.get_cpu_load()
        self.info.text += 'gain:%.2f\n' % self.mixer.get_gain()
        self.info.text += 'gens:%d\n' % self.mixer.get_num_generators()

    def on_key_down(self, keycode, modifiers):
        # number keys play pitches from kPitches (scale)
        p = lookup(keycode[1], '123456789', kPitches1)
        if p:
            gen = NoteGenerator(p, 0.5, 2.0, harmonics = NoteGenerator.sine)
            self.mixer.add(gen)

        # pick a gain
        gf = lookup(keycode[1], ('up', 'down'), (1.1, 1/1.1))
        if gf:
            new_gain = self.mixer.get_gain() * gf
            self.mixer.set_gain( new_gain )


# add wave file playback
# make new pitch set
kPitches2 = (61,63,65,66,68,70,73,75,78)

class MainWidget2(BaseWidget) :
    def __init__(self):
        super(MainWidget2, self).__init__()

        self.audio = Audio(2)
        self.mixer = Mixer()
        self.audio.set_generator(self.mixer)

        self.wave_file_gen = WaveFileGenerator("../data/superstition.wav")

        self.info = topleft_label()
        self.add_widget(self.info)

    def on_update(self) :
        self.audio.on_update()
        self.info.text = 'load:%.2f\n' % self.audio.get_cpu_load()
        self.info.text += 'gain:%.2f\n' % self.mixer.get_gain()
        self.info.text += 'gens:%d\n' % self.mixer.get_num_generators()

    def on_key_down(self, keycode, modifiers):
        # print 'key-down', keycode, modifiers

        # number keys play pitches from kPitches (scale)
        p = lookup(keycode[1], '123456789', kPitches1)
        if p:
            gen = NoteGenerator(p, 0.5, 1.0)
            self.mixer.add(gen)

        # pick a gain
        gf = lookup(keycode[1], ('up', 'down'), (1.1, 1/1.1))
        if gf:
            new_gain = self.mixer.get_gain() * gf
            self.mixer.set_gain( new_gain )

        if keycode[1] == 'p':
            print 'Wave'
            self.mixer.add(self.wave_file_gen)


## add buffer playback
class MainWidget3(BaseWidget) :
    def __init__(self):
        super(MainWidget3, self).__init__()

        self.audio = Audio(2)
        self.mixer = Mixer()
        self.audio.set_generator(self.mixer)

        self.wave_file_gen = WaveGenerator(WaveFile("../data/superstition.wav"))

        # create a WaveReader - knows how to get data from a wave file:
        self.buffer1 = WaveBuffer("../data/superstition.wav", int(Audio.sample_rate * 2), int(Audio.sample_rate * 2))
        self.buffer2 = WaveBuffer("../data/superstition.wav", int(Audio.sample_rate * 22), int(Audio.sample_rate * 1))

        self.info = topleft_label()
        self.add_widget(self.info)

    def on_update(self) :
        self.audio.on_update()
        self.info.text = 'load:%.2f\n' % self.audio.get_cpu_load()
        self.info.text += 'gain:%.2f\n' % self.mixer.get_gain()
        self.info.text += 'gens:%d\n' % self.mixer.get_num_generators()

    def on_key_down(self, keycode, modifiers):
        # print 'key-down', keycode, modifiers

        # number keys play pitches from kPitches (scale)
        p = lookup(keycode[1], '123456789', kPitches2)
        if p:
            gen = NoteGenerator(p, 0.5, 1.0)
            self.mixer.add(gen)

        # pick a gain
        gf = lookup(keycode[1], ('up', 'down'), (1.1, 1/1.1))
        if gf:
            new_gain = self.mixer.get_gain() * gf
            self.mixer.set_gain( new_gain )

        if keycode[1] == 'p':
            print 'Wave'
            self.mixer.add(self.wave_file_gen)

        # pick a buffer
        buf = lookup(keycode[1], 'as', (self.buffer1, self.buffer2))
        if buf:
            gen = WaveGenerator(buf)
            self.mixer.add(gen)


# pass in which MainWidget to run as a command-line arg
run(eval('MainWidget' + sys.argv[1]))
