# pset2.py

import sys
sys.path.append('..')
sys.path.append('../class2')

from common.core import *
from common.audio import *
from common.writer import *
from common.mixer import *
from common.note import *
from common.gfxutil import topleft_label
from wavesrc import *


# part 1: add shuttle controls to WaveGenerator
# part 3: add looping and release to WaveGenerator
class WaveGenerator(object):
    def __init__(self, wave_source, loop=False):
        super(WaveGenerator, self).__init__()
        self.source = wave_source
        self.frame = 0

    def reset(self):
        pass

    def play_toggle(self):
        pass

    def play(self):
        pass

    def pause(self):
        pass

    def release(self):
        pass

    def generate(self, num_frames, num_channels) :
        assert(num_channels == self.source.get_num_channels())

        # get data based on our position and requested # of frames
        output = self.source.get_frames(self.frame, self.frame + num_frames)

        # advance current-frame
        self.frame += num_frames

        # check for end-of-buffer condition:
        shortfall = num_frames * num_channels - len(output)
        continue_flag = shortfall == 0
        if shortfall > 0:
            output = np.append(output, np.zeros(shortfall))

        # return
        return (output, continue_flag)


# part 2
# Create a class to hold a region (start, length) and it's name
# If you'd like, check out collections.namedtuple as a nice way of automatically making
# a simple container class.
class AudioRegion(object):
    def __init__(self):
        super(AudioRegion, self).__init__()


# a collection of regions that are read from a file
class SongRegions(object):
    def __init__(self, filepath):
        super(SongRegions, self).__init__()

# return a dictionary of WaveBuffers
def make_wave_buffers(regions_path, wave_path):
    buffers = {}
    return buffers


# part 4: Create a generator that can modulate the speed of another generator
class SpeedModulator(object):
    def __init__(self, generator, speed = 1.0):
        super(SpeedModulator, self).__init__()

    def set_speed(self, speed) :
        pass

    def generate(self, num_frames, num_channels) :
        output = np.zeros(num_channels * num_frames)
        continue_flag = True
        return (output, continue_flag)


# Main app
class MainWidget(BaseWidget) :
    def __init__(self):
        super(MainWidget, self).__init__()

        self.writer = AudioWriter('data') # for debugging audio output
        self.audio = Audio(2, self.writer.add_audio)
        self.mixer = Mixer()
        self.audio.set_generator(self.mixer)

        self.wave_file_gen = WaveGenerator(WaveFile("../data/superstition.wav"))

        self.info = topleft_label()
        self.add_widget(self.info)

    def on_update(self) :
        self.audio.on_update()
        self.info.text = 'load:%.2f\n' % self.audio.get_cpu_load()
        self.info.text += 'gain:%.2f\n' % self.mixer.get_gain()

    def on_key_down(self, keycode, modifiers):
        print 'key-down', keycode, modifiers

        # adjust gain
        gf = lookup(keycode[1], ('up', 'down'), (1.1, 1/1.1))
        if gf:
            new_gain = self.mixer.get_gain() * gf
            self.mixer.set_gain( new_gain )

        if keycode[1] == 'w':
            print 'Wave'
            self.mixer.add(self.wave_file_gen)

        # toggle waveform debugging
        if keycode[1] == 'z':
            self.writer.toggle()

    def on_key_up(self, keycode) :
        print 'key-up', keycode

run(MainWidget)
