# Lab3 - Graphics

import sys
sys.path.append('..')
from common.core import *
from common.gfxutil import *

from kivy.core.window import Window
from kivy.graphics.instructions import InstructionGroup
from kivy.graphics import Color, Ellipse, Rectangle, Line
from kivy.graphics import PushMatrix, PopMatrix, Translate, Scale, Rotate

from random import random, randint
import math
import numpy as np


# Part 1: Below is a partial implementation of a FadingDot
# InstructionGroup extension.
# 
# All InstructionGroups do is define a group of instructions
# such as Color(), Rectangle(), Line(),
# or other Canvas Instructions. All of this is handled for you;
# observe how I'm calling the InstructionGroup superclass's
# .add() method to add instructions to the Group in order.
#
# Now look at ExerciseWidget, run it, and observe what it
# does.
#
# Part 1a. Make the dot get smaller and disappear after 2 seconds.
# 
# Part 1b. Add a method to ExerciseWidget so that the user can
# draw FadingDots all over the screen by holding and dragging the mouse
# button down.
#
# Remember to remove circles when they're small enough 

class FadingDot(InstructionGroup):
    def __init__(self, pos=(0,0), start_size=10):
        super(FadingDot, self).__init__()

        # make the dot white
        self.add(Color(1,1,1))

        self.dot = CEllipse(cpos=pos, segments = 20)
        self.dot.set_csize((start_size, start_size))
        self.add(self.dot)

    def on_update(self, dt):
        pass


class ExerciseWidget(BaseWidget):
    def __init__(self):
        super(ExerciseWidget, self).__init__()
        self.anim_group = AnimGroup()
        self.canvas.add(self.anim_group)

        self.info = topleft_label()
        self.add_widget(self.info)

    def on_update(self):
        self.anim_group.on_update()
        self.update_info_label()

    def on_touch_down(self, touch):
        self.anim_group.add(FadingDot(pos=touch.pos))

    ## Part 1b (add the method here) ##
    def on_touch_move(self,touch):
        pass

    def update_info_label(self):
        self.info.text = str(Window.mouse_pos)
        self.info.text += '\nfps:%d' % kivyClock.get_fps()
        self.info.text += '\nobjects:%d' % len(self.anim_group.objects)



# Part 2a:
# Create a new object called a StretchyLine - which derives from InstructionGroup.
# StretchyLine draws a line connecting two points using the kivy Line object.
# A line object can be created like this:
# self.line = Line(points=(x1, y1, x2, y2), width=w)
#
# Even though we only make a two-point line, Lines in general can have many more points
#
# Each line should have its own unique color based on the location of the line:
# We can use HSV (Hue Saturation, Value) as another way of specifiying a color.
# Color(hsv=(h,s,v)) will create a color with these three values (as opposed to R, G, B)
# Map the Left-Right position of the line midpoint to a hue range of 0-to-1. Use S = V = 1
#
# Finally, in ExerciseWidget, create this new StretchyLine object to 
# connect the current touch_down point and the previous touch_down point.
# Make it work for mouse dragging (ie, touch_move) as well
# 
# Part 2b:
# You will now animate this StretchyLine as follows:
# Say the line goes from point p1 to point p2. Find two "target points" that lie along the 
# slope of line but are far away from p1 and p2.
# Create an animation that makes the line grow from its current position (p1, p2) to the
# target position (target1, target2) in one second.
# Note: in order to animate a Line object, you must give it all new points like this:
# self.line.points = (x1, x2, y1, y2)
#
# Also, make the line fade out as it stretches out using Color alpha animation.
# Each Color object also has an "alpha" value that ranges from 1 (fully opaque) to 0 (fully transparent)
# By animating alpha from 1 to 0, you can fade out any object.
# To set the alpha of a color, do: self.color.a = alpha_value

class StretchyLine(InstructionGroup):
    def __init__(self, pos1, pos2):
        super(StretchyLine, self).__init__()

    def on_update(self, dt):
        pass


run(ExerciseWidget)

