#####################################################################
#
# particle_paint.py
#
# Copyright (c) 2015, Eran Egozy
#
# Released under the MIT License (http://opensource.org/licenses/MIT)
#
#####################################################################

#particle_test.py

# To edit a particle system pex file see this url:
# http://onebyonedesign.com/flash/particleeditor/

import sys
sys.path.append('..')

from common.core  import *
from common.gfxutil import *
from common.kivyparticle import ParticleSystem

from kivy.uix.label import Label
from kivy.clock import Clock as kivyClock

import numpy as np


class MainWidget(BaseWidget) :
    def __init__(self):
        super(MainWidget, self).__init__()

        # load up the particle system, set initial emitter point and start it.
        self.ps = ParticleSystem('particle/particle.pex')
        self.ps.emitter_x = 300.0
        self.ps.emitter_y = 300.0
        self.ps.start()
        self.add_widget(self.ps)

        # for dynamic color blending. Blend between originally set color and blue
        self.color1 = self.ps.start_color
        self.color2 = [0., 0., 1., 1.]    # blue!

        # and text to display our status
        self.label = topleft_label()
        self.add_widget(self.label)

        # for velocity measurements
        self.last_pos = np.array((0,0))

    def on_touch_down(self, touch) :
        pos = np.array(touch.pos)
        self.last_pos = pos
        self._update_mouse(pos)

    def on_touch_up(self, touch) :
        pos = np.array(touch.pos)
        self.last_pos = pos
        self._update_mouse(pos)

    def on_touch_move(self, touch) :
        pos = np.array(touch.pos)
        self._update_mouse(pos)


    def _update_mouse(self, pos) :
        # calculate velocity (must convert to a float, otherwise, type is numpy.float64)
        vel = float( np.linalg.norm(pos - self.last_pos) )
        self.last_pos = pos

        # set emitter location based on mouse position
        self.ps.emitter_x = pos[0]
        self.ps.emitter_y = pos[1]

        # change some ps parameters based on speed:
        self._set_color(vel / 40)
        self.ps.speed = 40 + (10*vel)


    def on_update(self) :
        self.label.text  = 'fps:%.1f\n' % kivyClock.get_fps()
        self.label.text += 'num_particles:%d\n' % self.ps.num_particles


    # helper function:
    def _set_color(self, x):
        # set start color to be a blend between color1 and color2
        clr = [a * x + b * (1 - x) for a,b in zip(self.color2, self.color1)]
        self.ps.start_color = clr


run(MainWidget)
