# pset3.py

import sys
sys.path.append('..')
from common.core import *
from common.gfxutil import *
from common.audio import *
from common.mixer import *
from common.note import *
from common.wavegen import *
from common.wavesrc import *

from kivy.core.window import Window
from kivy.clock import Clock as kivyClock
from kivy.uix.label import Label
from kivy.graphics.instructions import InstructionGroup
from kivy.graphics import Color, Ellipse, Rectangle
from kivy.graphics import PushMatrix, PopMatrix, Translate, Scale, Rotate

from random import random, randint
import numpy as np


# part 1
class MainWidget1(BaseWidget) :
    def __init__(self):
        super(MainWidget1, self).__init__()

        self.objects = AnimGroup()
        self.canvas.add(self.objects)

        self.info = topleft_label()
        self.add_widget(self.info)

    def on_touch_down(self, touch) :
        # initial settings. TODO - vary these.
        p = touch.pos
        r = 50
        c = (1,1,1)
        self.objects.add(Bubble(p, r, c))

    def on_update(self):
        self.objects.on_update()

        self.info.text = str(self.get_mouse_pos())
        self.info.text += '\nfps:%d' % kivyClock.get_fps()
        self.info.text += '\nobjects:%d' % len(self.objects.objects)

class Bubble(InstructionGroup):
    def __init__(self, pos, r, color):
        super(Bubble, self).__init__()

        # TODO - add animations

        self.color = Color(*color)
        self.add(self.color)

        self.circle = CEllipse(cpos = pos, size = (2*r, 2*r), segments = 40)
        self.add(self.circle)

        self.time = 0
        self.on_update(0)

    def on_update(self, dt):
        # advance time
        self.time += dt

        # TODO - update object properties based on animation system


        # TODO - return False when Bubble lifetime ends
        return True

# part 2
class MainWidget2(BaseWidget) :
    def __init__(self):
        super(MainWidget2, self).__init__()
        self.info = topleft_label()
        self.add_widget(self.info)

        # AnimGroup handles drawing, animation, and object lifetime management
        self.objects = AnimGroup()
        self.canvas.add(self.objects)

    def on_touch_down(self, touch) :
        # initial settings. TODO - vary these.
        p = touch.pos
        r = 50
        c = (1,1,1)

        self.objects.add(PhysBubble(p, r, c))

    def on_collide(self, bubble, vel) :
        pass

    def on_update(self):
        self.objects.on_update()

        self.info.text = str(self.get_mouse_pos())
        self.info.text += '\nfps:%d' % kivyClock.get_fps()
        self.info.text += '\nbubbles:%d' % self.objects.size()


gravity = np.array((0, -1800))
damping = 0.9

class PhysBubble(InstructionGroup):
    def __init__(self, pos, r, color):
        super(PhysBubble, self).__init__()

        self.radius = r
        self.pos = np.array(pos, dtype=np.float)
        self.vel = np.array((randint(-300, 300), 0), dtype=np.float)

        self.color = Color(*color)
        self.add(self.color)

        self.circle = CEllipse(cpos=pos, csize=(2*r,2*r), segments = 40)
        self.add(self.circle)

        self.on_update(0)

    def on_update(self, dt):
        # integrate accel to get vel
        self.vel += gravity * dt

        # integrate vel to get pos
        self.pos += self.vel * dt

        # collision with floor
        if self.pos[1] - self.radius < 0:
            self.vel[1] = -self.vel[1] * damping
            self.pos[1] = self.radius

        self.circle.cpos = self.pos

        return True


# part 3
class MainWidget3(BaseWidget) :
    def __init__(self):
        super(MainWidget3, self).__init__()

    def on_update(self):
        pass


run(eval('MainWidget' + sys.argv[1]))
