package data;

public class IndexedColumn<T> implements Column<T>
{
    public IndexedColumn()
    {
    }
    
    public IndexedColumn(int index, String name)
    {
        this.index = index;
        this.name = name;
    }
    
    public boolean equals(Object other_)
    {
        final IndexedColumn<T> other = (IndexedColumn<T>)other_;
        return index == other.index;
    }
    
    public int hashCode()
    {
        return index;
    }
    
    public String toString()
    {
        return name;
    }
    
    public int compareTo(Column<T> other_)
    {
        final IndexedColumn<T> other = (IndexedColumn<T>)other_;
        return index - other.index;
    }
    
    public String name()
    {
        return name;
    }
    
    public String fullName()
    {
        return name;
    }
    
    protected int index;
    protected String name;
}
