package data;

import data.Column;
import java.util.List;
import java.util.Map;

public final class SpreadsheetUtils
{
    public static double[] columnToArray(List<Map<Column, Object>> rows,
        Column<Double> column)
    {
        final double[] returnValue = new double[rows.size()];
        {
            int returnValueIndex = 0;
            for (Map<Column, Object> row : rows)
            {
                returnValue[returnValueIndex] = (Double)row.get(column);
                returnValueIndex++;
            }
        }
        return returnValue;
    }
    
    public static Double columnTrueFraction(List<Map<Column, Object>> rows,
        Column<Boolean> column)
    {
        int trueCount = 0;
        for (Map<Column, Object> row : rows)
        {
            if ((Boolean)row.get(column))
            {
                trueCount++;
            }
        }
        return (double)trueCount / (double)rows.size();
    }
}
