package util;

import static java.lang.Math.abs;
import static java.lang.Math.ceil;
import static java.lang.Math.floor;
import static java.lang.Math.log10;
import static java.lang.Math.pow;
import static java.lang.Math.round;

public final class Math
{
    public static abstract class RoundFunctor
    {
        public abstract double call(double value);
    }
    
    public static final RoundFunctor floor = new RoundFunctor()
    {
        public double call(double value)
        {
            return floor(value);
        }
    };
    public static final RoundFunctor ceil = new RoundFunctor()
    {
        public double call(double value)
        {
            return ceil(value);
        }
    };
    public static final RoundFunctor round = new RoundFunctor()
    {
        public double call(double value)
        {
            return round(value);
        }
    };
    
    public static double roundToResolution(RoundFunctor round,
        double resolution, double value)
    {
        return round.call(value / resolution) * resolution;
    }
    
    public static double roundToSignificandResolution(RoundFunctor round,
        double resolution, double value)
        /**
            @post The return value's significand in scientific notation will be
                a multiple of {@code resolution}.
        */
    {
        double returnValue = value;
        if (value != 0.)
        {
            double exponent = floor(log10(abs(value)));
            do
            {
                returnValue = roundToResolution(round,
                    resolution * pow(10., exponent), value);
                exponent--;
            }
            // Lower exponent until significand is big enough for resolution.
            while (returnValue == 0.);
        }
        return returnValue;
    }
}
