package util;

import java.text.DecimalFormat;

import static java.lang.Math.abs;

public final class Text
{
    public static final double scientificNotationThreshold = 1e3;
    
    public static String format(double value)
    {
        return new DecimalFormat(abs(value) >= scientificNotationThreshold
            ? "0.#E0" : "0.#").format(value);
    }
}
